/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.Directory;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.EnumSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;

public class DirectoryManagerTestAdminWithReadRights
extends TestBaseDMS {
    private static final Logger logger = Logger.getLogger(DirectoryManagerTestAdminWithReadRights.class);
    protected static String XID;
    private static Session newAdminSession;
    private static String dirPath;

    public void setUpSuite() {
        super.setUpSuite();
        DirectoryManagerTestAdminWithReadRights.breakdown(SetupConnection.session);
        EnumSet<Admin.Rights> enumSet = EnumSet.noneOf(Admin.Rights.class);
        EnumSet<Administrator.Flags> enumSet2 = EnumSet.noneOf(Administrator.Flags.class);
        DirectoryManagerTestAdminWithReadRights.createNewAdmin(SetupConnection.session, "CA.XPS::SecurityCategory@!Directory Administration", enumSet, enumSet2, null);
        String string = DirectoryManagerTestAdminWithReadRights.getSpec(SetupConnection.session);
        newAdminSession = DirectoryManagerTestAdminWithReadRights.login(SetupConnection.session, string);
        dirPath = this.getUserDirectoryPath();
    }

    @TestBase.STI(value=1)
    public void testGetDirectoryUsingEmptyStrings() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Authorized Admin using EMPTY dir namespace, path***");
        try {
            newAdminSession.getDirectoryManager().getDirectory("", "");
            DirectoryManagerTestAdminWithReadRights.fail((String)"getDirectory must fail with empty strings");
        }
        catch (ServerException serverException) {
            DirectoryManagerTestAdminWithReadRights.assertEquals((String)"Exception tag must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTestAdminWithReadRights.assertContains(serverException.getMsg(), "Namespace");
        }
    }

    @TestBase.STI(value=2)
    public void testGetDirectoryUsingEmptyXid() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (NEGATIVE) by Authorized Admin using EMPTY dir XID***");
        try {
            newAdminSession.getDirectoryManager().getDirectory("");
            DirectoryManagerTestAdminWithReadRights.fail((String)"getDirectory must fail with empty XID");
        }
        catch (ServerException serverException) {
            DirectoryManagerTestAdminWithReadRights.assertEquals((String)"Exception tag must match directoryManager.getDirectory", (String)serverException.getTag(), (String)"directoryManager.getDirectory");
            DirectoryManagerTestAdminWithReadRights.assertContains(serverException.getMsg(), "DirXid");
        }
    }

    @TestBase.STI(value=3)
    public void testGetDirectory() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (POSITIVE) by Authorized Admin using dir namespace, path***");
        Directory directory = newAdminSession.getDirectoryManager().getDirectory(strUDNamespace, dirPath);
        XID = directory.getXID();
        DirectoryManagerTestAdminWithReadRights.assertTrue((String)"The fetched directory XID must be of class CA.SM::UserDirectory", (boolean)XID.contains("CA.SM::UserDirectory"));
    }

    @TestBase.STI(value=4)
    public void testGetDirectoryUsingXid() throws XPSException {
        logger.debug((Object)"***Testing GetDirectory (POSITIVE) by Authorized Admin using dir XID***");
        newAdminSession.getDirectoryManager().getDirectory(XID);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryManagerTestAdminWithReadRights.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryManagerTestAdminWithReadRights.class);
    }

    static {
        newAdminSession = null;
        dirPath = null;
    }
}

