/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dictionary;

import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ClassTest
extends TestBase {
    @TestBase.STI(value=1)
    public void testSMClass() throws Exception {
        this.doCheckUP("CA", "SM", "AgentType", 7, null, 16, "CA.XPS::Class@CA.SM::AgentType");
        this.doCheckUP("CA", "SM", "GlobalPolicyLink", 1, "Policy", 5, "CA.XPS::Class@CA.SM::GlobalPolicyLink");
        this.doCheckUP("CA", "SM", "VariableType", 3, null, 30, "CA.XPS::Class@CA.SM::VariableType");
        this.doCheckUP("CA", "SM", "Rule", 14, "Realm", 11, "CA.XPS::Class@CA.SM::Rule");
        this.doCheckUP("CA", "SM", "Domain", 7, null, 3, "CA.XPS::Class@CA.SM::Domain");
    }

    @TestBase.STI(value=2)
    public void testXPSClass() throws Exception {
        this.doCheckUP("CA", "XPS", "Administrator", 6, null, -1, "CA.XPS::Class@CA.XPS::Administrator");
        this.doCheckUP("CA", "XPS", "Product", 6, null, -1, "CA.XPS::Class@CA.XPS::Product");
    }

    @TestBase.STI(value=3)
    public void testEPMClass() throws Exception {
        this.doCheckUP("CA", "EPM", "Application", 2, null, 0, "CA.XPS::Class@CA.EPM::Application");
        this.doCheckUP("CA", "EPM", "Role", 6, "Domain", 0, "CA.XPS::Class@CA.EPM::Role");
    }

    private void doCheckUP(String string, String string2, String string3, int n, String string4, int n2, String string5) {
        Class clazz = SetupConnection.dictionary.fetchClass(string, string2, string3);
        ClassTest.assertNotNull((String)"fetchClass returned null", (Object)clazz);
        List list = clazz.getAttributes();
        if (list.size() != n) {
            ClassTest.format(list);
        }
        ClassTest.assertSize("attributes", list, n);
        ClassTest.assertEquals((String)"Product name", (String)clazz.getProduct().getName(), (String)string2);
        ClassTest.assertEquals((String)"Vendor name", (String)clazz.getProduct().getVendor().getName(), (String)string);
        ClassTest.assertEquals((String)"Class name", (String)clazz.getName(), (String)string3);
        if (n2 != 0) {
            ClassTest.assertEquals((String)"SiteminderType", (int)clazz.getSiteMinderType(), (int)n2);
        }
        ClassTest.assertEquals((String)"Object XID", (String)clazz.getXid(), (String)string5);
        if (string4 != null) {
            ClassTest.assertEquals((String)"parentClass", (String)clazz.getParentClass().getName(), (String)string4);
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ClassTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ClassTest.class);
    }
}

