/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Variable;
import com.ca.siteminder.sdk.adminapi.ca.sm.VariableType;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class VariableTest
extends TestBase {
    static Domain domain;
    static Variable variable;

    @TestBase.STI(value=1)
    public void testCreateVariable() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestVariableUserDir" + SetupConnection.random, "TestVariableAgent1" + SetupConnection.random, null, "TestVariableDomain" + SetupConnection.random, null, null, null, null);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestVariableDomain" + SetupConnection.random);
        String string = "Variable" + SetupConnection.random;
        variable = this.makeVariable(string, domain);
        this.createObject((XPSObject)variable);
        List list = domain.getChildren((IClass)Variable.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Variable)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        VariableTest.assertTrue((String)"Variable, created, must found in existing Variable list", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchVariable() {
        SetupConnection.fetchByName(Variable.ddclass, variable.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateVariable() throws XPSException {
        variable.setName("update" + variable.getName());
        variable.setDesc("update" + variable.getDesc());
        this.updateObject((XPSObject)variable);
    }

    @TestBase.STI(value=4)
    public void testVariableDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)variable);
    }

    @TestBase.STI(value=5)
    public void testDeleteVariable() throws XPSException {
        this.deleteObject((XPSObject)variable);
        variable = null;
    }

    @TestBase.STI(value=6)
    public void testVariableWithoutName() throws XPSException {
        variable = this.makeVariable(null, domain);
        this.failCreate((XPSObject)variable, "Name");
    }

    @TestBase.STI(value=7)
    public void testVariableWithoutDomain() throws XPSException {
        String string = "Variable1" + SetupConnection.random;
        variable = this.makeVariable(string, null);
        this.failCreate((XPSObject)variable, "parent");
    }

    @TestBase.STI(value=8)
    public void testVariableWithoutVariableType() throws XPSException {
        String string = "Variable" + SetupConnection.random;
        variable = this.makeVariable(string, domain);
        variable.clearVariableType();
        this.failCreate((XPSObject)variable, "VariableTypeLink");
    }

    public Variable makeVariable(String string, Domain domain) throws XPSException {
        Variable variable = (Variable)SetupConnection.policyData.newObject((IClass)Variable.ddclass);
        if (string != null) {
            variable.setName(string);
        }
        if (domain != null) {
            variable.setParent(domain);
        }
        VariableType variableType = (VariableType)SetupConnection.fetchByName(VariableType.ddclass, "Post");
        variable.setVariableType(variableType);
        variable.setDesc("XPSAPI JUnit Sample Variable");
        variable.setDefinition("variable Type");
        variable.setPreFetchFlag(Boolean.valueOf(false));
        variable.setReturnType(Variable.ReturnType.Number);
        return variable;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)VariableTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(VariableTest.class);
    }
}

