/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class UserDirectoryTest
extends TestBase {
    static UserDirectory userDir;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateLDAPUserDirectory() throws XPSException {
        strName = "LDAPUserDirectory" + SetupConnection.random;
        userDir = ObjectBuilder.makeUserDirectory(strName);
        this.createObject((XPSObject)userDir);
    }

    @TestBase.STI(value=2)
    public void testSearchLDAPUserDirectory() {
        SetupConnection.fetchByName(UserDirectory.ddclass, userDir.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateLDAPUserDirectory() throws XPSException {
        userDir.setName("update" + userDir.getName());
        userDir.setDesc("update" + userDir.getDesc());
        this.updateObject((XPSObject)userDir);
    }

    @TestBase.STI(value=4)
    public void testLDAPUserDirectoryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)userDir);
    }

    @TestBase.STI(value=5)
    public void testDeleteLDAPUserDirectory() throws XPSException {
        this.deleteObject((XPSObject)userDir);
        userDir = null;
    }

    @TestBase.STI(value=6)
    public void testCreateODBCUserDirectory() throws XPSException {
        this.doODBCQuerySetup();
        String string = "ODBCUserDirectory" + SetupConnection.random;
        userDir = this.makeODBCUserDir(string);
        this.createObject((XPSObject)userDir);
    }

    @TestBase.STI(value=7)
    public void testSearchODBCUserDirectory() {
        SetupConnection.fetchByName(UserDirectory.ddclass, userDir.getName());
    }

    @TestBase.STI(value=8)
    public void testODBCUserDirectoryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)userDir);
    }

    @TestBase.STI(value=9)
    public void testDeleteODBCUserDirectory() throws XPSException {
        this.deleteObject((XPSObject)userDir);
        userDir = null;
    }

    @TestBase.STI(value=10)
    public void testUserDirectoryWithoutName() throws XPSException {
        userDir = ObjectBuilder.makeUserDirectory(null);
        this.failCreate((XPSObject)userDir, "Name");
    }

    @TestBase.STI(value=11)
    public void testUserDirectoryWithoutServer() throws XPSException {
        String string = "UserDirectory2" + SetupConnection.random;
        userDir = ObjectBuilder.makeUserDirectory(string);
        userDir.clearServer();
        this.failCreate((XPSObject)userDir, "Server");
    }

    @TestBase.STI(value=12)
    public void testODBCUserDirectoryWithoutQuery() throws XPSException {
        String string = "ODBCUserDirectory2" + SetupConnection.random;
        userDir = this.makeODBCUserDir(string);
        userDir.clearODBCQuery();
        this.failCreate((XPSObject)userDir, "ODBCQuery");
    }

    @TestBase.STI(value=13)
    public void testServer1() throws XPSException {
        userDir = ObjectBuilder.makeUserDirectory(strName + 1);
        userDir.setServer("foo:abc");
        this.failCreate((XPSObject)userDir, "foo:abc");
    }

    @TestBase.STI(value=14)
    public void testServer2() throws XPSException {
        userDir = ObjectBuilder.makeUserDirectory(strName + 2);
        userDir.setServer("foo:12a");
        this.failCreate((XPSObject)userDir, "foo:12a");
    }

    @TestBase.STI(value=15)
    public void testServer3() throws XPSException {
        userDir = ObjectBuilder.makeUserDirectory(strName + 3);
        userDir.setServer("foo:65536");
        this.failCreate((XPSObject)userDir, "foo:65536");
    }

    private UserDirectory makeODBCUserDir(String string) throws XPSException {
        ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.fetchByName(ODBCQuery.ddclass, "testUserDirODBC" + SetupConnection.random);
        UserDirectory userDirectory = ObjectBuilder.makeUserDirectory(string);
        userDirectory.setNamespace("ODBC:");
        userDirectory.setODBCQuery(oDBCQuery);
        return userDirectory;
    }

    private void doODBCQuerySetup() {
        ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
        oDBCQuery.setName("testUserDirODBC" + SetupConnection.random);
        this.createObject((XPSObject)oDBCQuery);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserDirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(UserDirectoryTest.class);
    }
}

