/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.RuleGroup;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RuleGroupTest
extends TestBase {
    static RuleGroup ruleGroup;
    static Rule rule;
    static Domain domain;

    @TestBase.STI(value=1)
    public void testCreateRuleGroup() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestRuleGroupUserDir" + SetupConnection.random, "TestRuleGroupAgent" + SetupConnection.random, null, "TestRuleGroupDomain" + SetupConnection.random, "TestRuleGroupRealm" + SetupConnection.random, "TestRuleGroupRule" + SetupConnection.random, null, null);
        rule = (Rule)SetupConnection.fetchByName(Rule.ddclass, "TestRuleGroupRule" + SetupConnection.random);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestRuleGroupDomain" + SetupConnection.random);
        String string = "RuleGroup" + SetupConnection.random;
        ruleGroup = RuleGroupTest.makeRuleGroup(string, domain, rule);
        this.createObject((XPSObject)ruleGroup);
        List list = domain.getChildren((IClass)RuleGroup.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((RuleGroup)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        RuleGroupTest.assertTrue((String)"Rule group, created, must found in the existing Rule groups", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchRuleGroup() {
        SetupConnection.fetchByName(RuleGroup.ddclass, ruleGroup.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRuleGroup() throws XPSException {
        ruleGroup.setName("update" + ruleGroup.getName());
        ruleGroup.setDesc("update" + ruleGroup.getDesc());
        this.updateObject((XPSObject)ruleGroup);
    }

    @TestBase.STI(value=4)
    public void testRuleGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)ruleGroup);
    }

    @TestBase.STI(value=5)
    public void testDeleteRuleGroup() throws XPSException {
        this.deleteObject((XPSObject)ruleGroup);
        ruleGroup = null;
    }

    @TestBase.STI(value=6)
    public void testRuleGroupWithoutName() throws XPSException {
        RuleGroup ruleGroup = RuleGroupTest.makeRuleGroup(null, domain, rule);
        this.failCreate((XPSObject)ruleGroup, "Name");
    }

    @TestBase.STI(value=7)
    public void testRuleGroupWithoutParent() throws XPSException {
        String string = "RuleGroup" + SetupConnection.random;
        RuleGroup ruleGroup = RuleGroupTest.makeRuleGroup(string, null, rule);
        this.failCreate((XPSObject)ruleGroup, "parent");
    }

    @TestBase.STI(value=8)
    public void testRuleGroupWithoutAgentType() throws XPSException {
        String string = "RuleGroup" + SetupConnection.random;
        RuleGroup ruleGroup = RuleGroupTest.makeRuleGroup(string, domain, rule);
        ruleGroup.clearAgentType();
        this.failCreate((XPSObject)ruleGroup, "AgentTypeLink");
    }

    public static RuleGroup makeRuleGroup(String string, Domain domain, Rule rule) throws XPSException {
        RuleGroup ruleGroup = (RuleGroup)SetupConnection.policyData.newObject((IClass)RuleGroup.ddclass);
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        if (string != null) {
            ruleGroup.setName(string);
        }
        if (domain != null) {
            ruleGroup.setParent(domain);
        }
        if (rule != null) {
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            arrayList.add(rule);
            ruleGroup.setRules(arrayList);
        }
        ruleGroup.setDesc("XPSAPI JUnit Sample RuleGroup");
        ruleGroup.setAgentType(agentType);
        return ruleGroup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RuleGroupTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RuleGroupTest.class);
    }
}

