/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentTypeAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.ResponseAttr;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ResponseAttrTest
extends TestBase {
    static Response response;
    static ResponseAttr responseAttr;

    @TestBase.STI(value=1)
    public void testCreateResponseAttr() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestResponseAttrUserDir" + SetupConnection.random, "TestResponseAttrAgent1" + SetupConnection.random, null, "TestResponseAttrDomain" + SetupConnection.random, null, null, "TestResponseAttrResponse" + SetupConnection.random, null);
        response = (Response)SetupConnection.fetchByName(Response.ddclass, "TestResponseAttrResponse" + SetupConnection.random);
        String string = "ResponseAttr" + SetupConnection.random;
        responseAttr = this.makeResponseAttr(string, response);
        this.createObject((XPSObject)responseAttr);
        List list = response.getChildren((IClass)ResponseAttr.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((ResponseAttr)list.get(i)).getValue().equals(string)) continue;
            bl = true;
        }
        ResponseAttrTest.assertTrue((String)"ResponseAttr, created, must found in the existing Respose attributes", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchResponseAttr() {
        Filter filter = new Filter((IAttribute)ResponseAttr.VALUE, Clause.Operator.EQUAL, (Object)responseAttr.getValue());
        List list = SetupConnection.policyData.search((IClass)ResponseAttr.ddclass, filter);
        ResponseAttrTest.assertFalse((String)"policyData.search returned empty ResponseAttr list", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateResponseAttr() throws XPSException {
        responseAttr.setValue("update" + responseAttr.getValue());
        this.updateObject((XPSObject)responseAttr);
    }

    @TestBase.STI(value=4)
    public void testResponseAttrDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)responseAttr);
    }

    @TestBase.STI(value=5)
    public void testDeleteResponseAttr() throws XPSException {
        this.deleteObject((XPSObject)responseAttr);
        responseAttr = null;
    }

    @TestBase.STI(value=6)
    public void testResponseAttrWithoutResponse() throws XPSException {
        String string = "ResponseAttr2" + SetupConnection.random;
        ResponseAttr responseAttr = this.makeResponseAttr(string, null);
        this.failCreate((XPSObject)responseAttr, "parent");
    }

    @TestBase.STI(value=7)
    public void testResponseWithoutAgentTypeAttr() throws XPSException {
        String string = "ResponseAttr2" + SetupConnection.random;
        responseAttr = this.makeResponseAttr(string, response);
        responseAttr.clearAgentTypeAttr();
        this.failCreate((XPSObject)responseAttr, "AgentTypeAttrLink");
    }

    private ResponseAttr makeResponseAttr(String string, Response response) throws XPSException {
        ResponseAttr responseAttr = (ResponseAttr)SetupConnection.policyData.newObject((IClass)ResponseAttr.ddclass);
        AgentTypeAttr agentTypeAttr = (AgentTypeAttr)SetupConnection.fetchByName(AgentTypeAttr.ddclass, "ServletAgent-HTTP-Cookie-Variable");
        if (string != null) {
            responseAttr.setValue(string);
        }
        if (response != null) {
            responseAttr.setParent(response);
        }
        responseAttr.setAgentTypeAttr(agentTypeAttr);
        responseAttr.setFlags(Integer.valueOf(0));
        responseAttr.setTTL(Integer.valueOf(0));
        responseAttr.setActiveExprString("ab = cd");
        return responseAttr;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResponseAttrTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ResponseAttrTest.class);
    }
}

