/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.RuleGroup;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.RuleGroupTest;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class PolicyLinkTest
extends TestBase {
    static PolicyLink policyLink;
    static Policy policy;
    static Rule rule;
    static Domain domain;

    @TestBase.STI(value=1)
    public void testCreatePolicyLink() throws XPSException {
        String string = "TestPolicy" + SetupConnection.random;
        String string2 = "TestPolicyLinkDomain" + SetupConnection.random;
        String string3 = "TestPolicyLinkRule" + SetupConnection.random;
        SetupConnection.builder.doDomainSetUp("TestPolicyLinkUserDir" + SetupConnection.random, "TestPolicyLinkAgent1" + SetupConnection.random, null, string2, "TestPolicyLinkRealm" + SetupConnection.random, string3, "TestPolicyLinkResponse" + SetupConnection.random, string);
        policy = (Policy)SetupConnection.fetchByName(Policy.ddclass, string);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, string2);
        rule = (Rule)SetupConnection.fetchByName(Rule.ddclass, string3);
        policyLink = PolicyLinkTest.makePolicyLink(policy, rule);
        this.createObject((XPSObject)policyLink);
    }

    @TestBase.STI(value=2)
    public void testSearchPolicyLink() {
        Filter filter = new Filter((IAttribute)PolicyLink.RULE, Clause.Operator.EQUAL, (Object)rule);
        List list = SetupConnection.policyData.search((IClass)PolicyLink.ddclass, filter);
        PolicyLinkTest.assertFalse((String)"policyData.search returned empty policyLinks", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdatePolicyLink() throws XPSException {
        policyLink.clearResponse();
        this.updateObject((XPSObject)policyLink);
    }

    @TestBase.STI(value=4)
    public void testPolicyLinkDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)policyLink);
    }

    @TestBase.STI(value=5)
    public void testDeletePolicyLink() throws XPSException {
        this.deleteObject((XPSObject)policyLink);
        policyLink = null;
    }

    @TestBase.STI(value=6)
    public void testPolicyLinkWithoutParent() throws XPSException {
        policyLink = PolicyLinkTest.makePolicyLink(null, rule);
        this.failCreate((XPSObject)policyLink, "parent");
    }

    @TestBase.STI(value=7)
    public void testPolicyLinkWithoutRule() throws XPSException {
        policyLink = PolicyLinkTest.makePolicyLink(policy, null);
        this.failCreate((XPSObject)policyLink, "Rule");
    }

    @TestBase.STI(value=8)
    public void testPolicyLinkWithGroups() throws XPSException {
        String string = "RuleGroup" + SetupConnection.random;
        RuleGroup ruleGroup = RuleGroupTest.makeRuleGroup(string, domain, rule);
        this.createObject((XPSObject)ruleGroup);
        policyLink = PolicyLinkTest.makePolicyLink(policy, null);
        policyLink.setRuleGroup(ruleGroup);
        this.createObject((XPSObject)policyLink);
        policyLink.setRule(rule);
        this.failUpdate((XPSObject)policyLink, "Both");
    }

    public static PolicyLink makePolicyLink(Policy policy, Rule rule) throws XPSException {
        PolicyLink policyLink = (PolicyLink)SetupConnection.policyData.newObject((IClass)PolicyLink.ddclass);
        if (policy != null) {
            policyLink.setParent(policy);
        }
        if (rule != null) {
            policyLink.setRule(rule);
        }
        Response response = (Response)SetupConnection.fetchByName(Response.ddclass, "TestPolicyLinkResponse" + SetupConnection.random);
        policyLink.setResponse(response);
        return policyLink;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PolicyLinkTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(PolicyLinkTest.class);
    }
}

