/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.PasswordPolicy;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class PasswordPolicyTest
extends TestBase {
    static String strName;
    static PasswordPolicy pwdPolicy;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreatePasswordPolicy() throws XPSException {
        userDir = ObjectBuilder.doUserDirSetUp("TestPasswordUserDir" + SetupConnection.random);
        strName = "PasswordPolicy" + SetupConnection.random;
        pwdPolicy = ObjectBuilder.makePasswordPolicy(strName, userDir);
        this.createObject((XPSObject)pwdPolicy);
    }

    @TestBase.STI(value=2)
    public void testSearchPasswordPolicy() {
        SetupConnection.fetchByName(PasswordPolicy.ddclass, pwdPolicy.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdatePasswordPolicy() throws XPSException {
        pwdPolicy.setName("update" + pwdPolicy.getName());
        pwdPolicy.setDesc("update" + pwdPolicy.getDesc());
        this.updateObject((XPSObject)pwdPolicy);
    }

    @TestBase.STI(value=4)
    public void testPasswordPolicyDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)pwdPolicy);
    }

    @TestBase.STI(value=5)
    public void testDeletePasswordPolicy() throws XPSException {
        this.deleteObject((XPSObject)pwdPolicy);
        pwdPolicy = null;
    }

    @TestBase.STI(value=6)
    public void testPasswordPolicyWithoutName() throws XPSException {
        pwdPolicy = ObjectBuilder.makePasswordPolicy(null, userDir);
        this.failCreate((XPSObject)pwdPolicy, "Name");
    }

    @TestBase.STI(value=7)
    public void testPasswordPolicyWithoutUserDir() throws XPSException {
        strName = "PasswordPolicy1" + SetupConnection.random;
        pwdPolicy = ObjectBuilder.makePasswordPolicy(strName, null);
        this.failCreate((XPSObject)pwdPolicy, "UserDirectoryLink");
    }

    @TestBase.STI(value=8)
    public void testPasswordPolicyWithoutClass() throws XPSException {
        strName = "PasswordPolicy2" + SetupConnection.random;
        pwdPolicy = ObjectBuilder.makePasswordPolicy(strName, userDir);
        pwdPolicy.clear_class();
        this.failCreate((XPSObject)pwdPolicy, "Class");
    }

    @TestBase.STI(value=9)
    public void testPasswordPolicyWrongValue() throws XPSException {
        strName = "PasswordPolicy3" + SetupConnection.random;
        pwdPolicy = ObjectBuilder.makePasswordPolicy(strName, userDir);
        pwdPolicy.setPWMinAlphaNum(Integer.valueOf(-1));
        this.createObject((XPSObject)pwdPolicy);
        pwdPolicy.setPWMinAlphaNum(Integer.valueOf(-2));
        this.failUpdate((XPSObject)pwdPolicy, "PWMinAlphaNum");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)PasswordPolicyTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(PasswordPolicyTest.class);
    }
}

