/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AgentTypeTest
extends TestBase {
    static AgentType agentType;

    @TestBase.STI(value=1)
    public void testCreateAgentType() throws XPSException {
        String string = "AgentType" + SetupConnection.random;
        agentType = this.makeAgentType(string);
        this.createObject((XPSObject)agentType);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentType() {
        SetupConnection.fetchByName(AgentType.ddclass, agentType.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgentType() throws XPSException {
        agentType.setName("update" + agentType.getName());
        agentType.setDesc("update" + agentType.getDesc());
        this.updateObject((XPSObject)agentType);
    }

    @TestBase.STI(value=4)
    public void testAgentTypeDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agentType);
    }

    @TestBase.STI(value=5)
    public void testDeleteAgentType() throws XPSException {
        this.deleteObject((XPSObject)agentType);
        agentType = null;
    }

    @TestBase.STI(value=6)
    public void testAgentTypeWithoutName() throws XPSException {
        agentType = this.makeAgentType(null);
        this.failCreate((XPSObject)agentType, "Name");
    }

    private AgentType makeAgentType(String string) throws XPSException {
        AgentType agentType = (AgentType)SetupConnection.policyData.newObject((IClass)AgentType.ddclass);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Authenticate");
        if (string != null) {
            agentType.setName(string);
        }
        agentType.setDesc("XPSAPI JUnit Sample AgentType");
        agentType.setRfcId(Integer.valueOf(0));
        agentType.setVendorType(AgentType.VendorType.WebAgent);
        agentType.setResourceType(AgentType.ResourceType.None);
        agentType.setVendorSpecificBytes(Integer.valueOf(0));
        agentType.setActions(arrayList);
        return agentType;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AgentTypeTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentTypeTest.class);
    }
}

