/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentConfig;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.STIHarness;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;

public class AgentConfigTest
extends TestBase {
    static AgentConfig agentConf;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateAgentConfig() throws XPSException {
        strName = "AgentConfig" + SetupConnection.random;
        agentConf = AgentConfigTest.makeAgentConfig(strName);
        this.createObject((XPSObject)agentConf);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentConfig() {
        SetupConnection.fetchByName(AgentConfig.ddclass, agentConf.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgentConfig() throws XPSException {
        agentConf.setName("update" + agentConf.getName());
        agentConf.setDesc("update" + agentConf.getDesc());
        this.updateObject((XPSObject)agentConf);
    }

    @TestBase.STI(value=4)
    public void testAgentConfigTestDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agentConf);
    }

    @TestBase.STI(value=5)
    public void testDeleteAgentConfig() throws XPSException {
        this.deleteObject((XPSObject)agentConf);
        agentConf = null;
    }

    @TestBase.STI(value=6)
    public void testAgentConfigWithoutName() throws XPSException {
        agentConf = AgentConfigTest.makeAgentConfig(null);
        this.failCreate((XPSObject)agentConf, "Name");
    }

    @TestBase.STI(value=7)
    public void testAgentConfigAttributes1() throws XPSException {
        agentConf = AgentConfigTest.makeAgentConfig(strName + 1);
        agentConf.setAttributes(Collections.singletonList("abcde"));
        this.failCreate((XPSObject)agentConf, "<key>=<flags>=<value>");
    }

    @TestBase.STI(value=8)
    public void testAgentConfigAttributes2() throws XPSException {
        agentConf = AgentConfigTest.makeAgentConfig(strName + 1);
        agentConf.setAttributes(Collections.singletonList("abc=de"));
        this.failCreate((XPSObject)agentConf, "<key>=<flags>=<value>");
    }

    @TestBase.STI(value=9)
    public void testAgentConfigAttributes3() throws XPSException {
        agentConf = AgentConfigTest.makeAgentConfig(strName + 1);
        agentConf.setAttributes(Collections.singletonList("abc=a=de"));
        this.failCreate((XPSObject)agentConf, "integer");
    }

    @TestBase.STI(value=10)
    public void createAttributes() {
        int n = 200;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String string = "aaaa" + i + "=0=value" + i;
            arrayList.add(string);
        }
        agentConf.setAttributes(arrayList);
        this.createObject((XPSObject)agentConf);
        AgentConfigTest.assertSize("attrs", agentConf.getAttributes(), n);
    }

    public static AgentConfig makeAgentConfig(String string) throws XPSException {
        AgentConfig agentConfig = (AgentConfig)SetupConnection.policyData.newObject((IClass)AgentConfig.ddclass);
        if (string != null) {
            agentConfig.setName(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Id=2=9999");
        arrayList.add("Enable=1=yes");
        arrayList.add("LogFile=3=no");
        arrayList.add("#commented=0=no");
        agentConfig.setDesc("XPSAPI JUnit Sample AgentConfig");
        agentConfig.setAttributes(arrayList);
        return agentConfig;
    }

    public static void main(String[] stringArray) {
        STIHarness.run(AgentConfigTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentConfigTest.class);
    }
}

