/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSScreen;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSScreenTest
extends TestBase {
    static IMSScreen imsScreen = null;

    @TestBase.STI(value=1)
    public void testCreateIMSScreen() throws XPSException {
        String string = "IMSScreen" + SetupConnection.random;
        imsScreen = SetupConnection.builder.makeIMSScreen(string);
        this.createObject((XPSObject)imsScreen);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSScreen() {
        SetupConnection.fetchByAttr(IMSScreen.ddclass, "Tag", imsScreen.getTag());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSScreen() throws XPSException {
        imsScreen.setTag("update" + imsScreen.getTag());
        this.updateObject((XPSObject)imsScreen);
    }

    @TestBase.STI(value=4)
    public void testIMSScreenDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsScreen);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSScreen() throws XPSException {
        this.deleteObject((XPSObject)imsScreen);
        imsScreen = null;
    }

    @TestBase.STI(value=6)
    public void testIMSScreenWithoutTag() throws XPSException {
        String string = "IMSScreen2" + SetupConnection.random;
        imsScreen = SetupConnection.builder.makeIMSScreen(string);
        imsScreen.clearTag();
        this.failCreate((XPSObject)imsScreen, "Tag");
    }

    @TestBase.STI(value=7)
    public void testIMSScreenWithoutObjectType() throws XPSException {
        String string = "IMSScreen3" + SetupConnection.random;
        imsScreen = SetupConnection.builder.makeIMSScreen(string);
        imsScreen.clearObjectType();
        this.failCreate((XPSObject)imsScreen, "ObjectType");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSScreenTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSScreenTest.class);
    }
}

