/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSRoleRule;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSRoleRuleTest
extends TestBase {
    static IMSRoleRule imsRoleRule = null;

    @TestBase.STI(value=1)
    public void testCreateIMSRoleRule() throws XPSException {
        String string = "IMSRoleRule" + SetupConnection.random;
        imsRoleRule = SetupConnection.builder.makeIMSRoleRule(string);
        this.createObject((XPSObject)imsRoleRule);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSRoleRule() {
        SetupConnection.fetchByName(IMSRoleRule.ddclass, imsRoleRule.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSRoleRule() throws XPSException {
        imsRoleRule.setName("update" + imsRoleRule.getName());
        this.updateObject((XPSObject)imsRoleRule);
    }

    @TestBase.STI(value=4)
    public void testIMSRoleRuleDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsRoleRule);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSRoleRule() throws XPSException {
        this.deleteObject((XPSObject)imsRoleRule);
        imsRoleRule = null;
    }

    @TestBase.STI(value=6)
    public void testIMSRoleRuleWithoutName() throws XPSException {
        imsRoleRule = SetupConnection.builder.makeIMSRoleRule(null);
        this.failCreate((XPSObject)imsRoleRule, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSRoleRuleWithoutSource() throws XPSException {
        String string = "IMSRoleRule2" + SetupConnection.random;
        imsRoleRule = SetupConnection.builder.makeIMSRoleRule(string);
        imsRoleRule.clearSource();
        this.failCreate((XPSObject)imsRoleRule, "Source");
    }

    @TestBase.STI(value=8)
    public void testIMSRoleRuleWithoutCompiled() throws XPSException {
        String string = "IMSRoleRule3" + SetupConnection.random;
        imsRoleRule = SetupConnection.builder.makeIMSRoleRule(string);
        imsRoleRule.clearCompiled();
        this.failCreate((XPSObject)imsRoleRule, "Compiled");
    }

    @TestBase.STI(value=9)
    public void testIMSRoleRuleWithoutEvalType() throws XPSException {
        String string = "IMSRoleRule4" + SetupConnection.random;
        imsRoleRule = SetupConnection.builder.makeIMSRoleRule(string);
        imsRoleRule.clearEvalType();
        this.failCreate((XPSObject)imsRoleRule, "EvalType");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSRoleRuleTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSRoleRuleTest.class);
    }
}

