/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSEnvironment;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSEnvironmentTest
extends TestBase {
    static IMSEnvironment imsEnvironment = null;

    @TestBase.STI(value=1)
    public void testCreateIMSEnvironment() throws XPSException {
        String string = "IMSEnvironment" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        this.createObject((XPSObject)imsEnvironment);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSEnvironment() {
        SetupConnection.fetchByName(IMSEnvironment.ddclass, imsEnvironment.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSEnvironment() throws XPSException {
        imsEnvironment.setName("update" + imsEnvironment.getName());
        imsEnvironment.setDescription("update" + imsEnvironment.getDescription());
        this.updateObject((XPSObject)imsEnvironment);
    }

    @TestBase.STI(value=4)
    public void testIMSEnvironmentDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsEnvironment);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSEnvironment() throws XPSException {
        this.deleteObject((XPSObject)imsEnvironment);
        imsEnvironment = null;
    }

    @TestBase.STI(value=6)
    public void testIMSEnvironmentWithoutName() throws XPSException {
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(null);
        this.failCreate((XPSObject)imsEnvironment, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSEnvironmentWithoutLogicalDirectory() throws XPSException {
        String string = "IMSEnvironment2" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        imsEnvironment.clearLogicalDirectory();
        this.failCreate((XPSObject)imsEnvironment, "LogicalDirectory");
    }

    @TestBase.STI(value=8)
    public void testIMSEnvironmentWithoutProtectedAlias() throws XPSException {
        String string = "IMSEnvironment3" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        imsEnvironment.clearProtectedAlias();
        this.failCreate((XPSObject)imsEnvironment, "ProtectedAlias");
    }

    @TestBase.STI(value=9)
    public void testIMSEnvironmentWithoutVersion() throws XPSException {
        String string = "IMSEnvironment4" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        imsEnvironment.clearVersion();
        this.failCreate((XPSObject)imsEnvironment, "Version");
    }

    @TestBase.STI(value=10)
    public void testIMSEnvironmentWithoutRoleSecurityAgent() throws XPSException {
        String string = "IMSEnvironment5" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        imsEnvironment.clearRoleSecurityAgent();
        this.failCreate((XPSObject)imsEnvironment, "RoleSecurityAgent");
    }

    @TestBase.STI(value=11)
    public void testIMSEnvironmentWithoutDomain() throws XPSException {
        String string = "IMSEnvironment6" + SetupConnection.random;
        imsEnvironment = SetupConnection.builder.makeIMSEnvironment(string);
        imsEnvironment.clearDomain();
        this.failCreate((XPSObject)imsEnvironment, "Domain");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSEnvironmentTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSEnvironmentTest.class);
    }
}

