/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSDirectory;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSDirectoryTest
extends TestBase {
    static IMSDirectory imsDirectory = null;

    @TestBase.STI(value=1)
    public void testCreateIMSDirectory() throws XPSException {
        String string = "IMSDirectory" + SetupConnection.random;
        imsDirectory = SetupConnection.builder.makeIMSDirectory(string);
        this.createObject((XPSObject)imsDirectory);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSDirectory() {
        SetupConnection.fetchByName(IMSDirectory.ddclass, imsDirectory.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSDirectory() throws XPSException {
        imsDirectory.setName("update" + imsDirectory.getName());
        imsDirectory.setDescription("update" + imsDirectory.getDescription());
        this.updateObject((XPSObject)imsDirectory);
    }

    @TestBase.STI(value=4)
    public void testIMSDirectoryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsDirectory);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSDirectory() throws XPSException {
        this.deleteObject((XPSObject)imsDirectory);
        imsDirectory = null;
    }

    @TestBase.STI(value=6)
    public void testIMSDirectoryWithoutName() throws XPSException {
        imsDirectory = SetupConnection.builder.makeIMSDirectory(null);
        this.failCreate((XPSObject)imsDirectory, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSDirectoryWithoutProviderLibrary() throws XPSException {
        String string = "IMSDirectory2" + SetupConnection.random;
        imsDirectory = SetupConnection.builder.makeIMSDirectory(string);
        imsDirectory.clearProviderLibrary();
        this.failCreate((XPSObject)imsDirectory, "ProviderLibrary");
    }

    @TestBase.STI(value=8)
    public void testIMSDirectoryWithoutVersion() throws XPSException {
        String string = "IMSDirectory3" + SetupConnection.random;
        imsDirectory = SetupConnection.builder.makeIMSDirectory(string);
        imsDirectory.clearVersion();
        this.failCreate((XPSObject)imsDirectory, "Version");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSDirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSDirectoryTest.class);
    }
}

