/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.fss;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.PolicyLink;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.ca.sm.ResponseAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Rule;
import com.ca.siteminder.sdk.adminapi.ca.sm.SAMLv1SP;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SAMLv1SPTest
extends TestBase {
    static SAMLv1SP sAMLv1SP;
    static Domain domain;

    @TestBase.STI(value=1)
    public void testCreateSAMLv1SP() throws XPSException {
        domain = SetupConnection.builder.doDomainSetUp("TestSAMLv1SPUserDir" + SetupConnection.random, "TestSAMLv1SPAgent1" + SetupConnection.random, null, "TestSAMLv1SPDomain" + SetupConnection.random, "TestSAMLv1SPRealm" + SetupConnection.random, "TestSAMLv1SPRule" + SetupConnection.random, "TestSAMLv1SPResponse" + SetupConnection.random, "TestSAMLv1SPPolicy" + SetupConnection.random);
        String string = "samlv1sp" + SetupConnection.random;
        sAMLv1SP = this.makeSAMLv1SP(string, domain);
        this.createObject((XPSObject)sAMLv1SP);
        List list = domain.getChildren((IClass)SAMLv1SP.ddclass);
        SAMLv1SPTest.assertTrue((String)"SAMLv1SP, created, must found in existing SAMLv1SP list", (boolean)list.contains(sAMLv1SP));
        String string2 = "affiliate:" + string;
        Agent agent = sAMLv1SP.getAgent();
        SAMLv1SPTest.assertNotNull((String)"Backing agent not found", (Object)agent);
        SAMLv1SPTest.assertEquals((String)"Backing agent has a wrong name", (String)string2.toLowerCase(), (String)agent.getName());
        Realm realm = sAMLv1SP.getRealm();
        SAMLv1SPTest.assertNotNull((String)"Backing realm not found", (Object)realm);
        SAMLv1SPTest.assertEquals((String)"Backing realm has a wrong name", (String)string2, (String)realm.getName());
        Rule rule = sAMLv1SP.getRule();
        SAMLv1SPTest.assertNotNull((String)"Backing rule not found", (Object)rule);
        SAMLv1SPTest.assertEquals((String)"Backing rule has a wrong name", (String)string2, (String)rule.getName());
        Policy policy = sAMLv1SP.getPolicy();
        SAMLv1SPTest.assertNotNull((String)"Backing policy not found", (Object)policy);
        SAMLv1SPTest.assertEquals((String)"Backing policy has a wrong name", (String)string2, (String)policy.getName());
        Response response = sAMLv1SP.getResponse();
        SAMLv1SPTest.assertNotNull((String)"Backing response not found", (Object)response);
        SAMLv1SPTest.assertEquals((String)"Backing response has a wrong name", (String)string2, (String)response.getName());
        List list2 = policy.getChildren((IClass)PolicyLink.ddclass);
        SAMLv1SPTest.assertNotNull((String)"Backing policy link not found", (Object)list2);
        SAMLv1SPTest.assertEquals((String)"Wrong number of backing policy links", (int)1, (int)list2.size());
        List list3 = response.getChildren((IClass)ResponseAttr.ddclass);
        SAMLv1SPTest.assertNotNull((String)"Backing response attribute not found", (Object)list3);
        SAMLv1SPTest.assertEquals((String)"Wrong number of backing response attributes", (int)1, (int)list3.size());
    }

    @TestBase.STI(value=2)
    public void testSearchSAMLv1SP() throws XPSException {
        SetupConnection.fetchByName(SAMLv1SP.ddclass, sAMLv1SP.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAliasForward() throws XPSException {
        SAMLv1SPTest.skip("Raised RTC defect 138701 to see why this is consistently failing");
        sAMLv1SP.getPolicy().setIsEnabled(Boolean.valueOf(false));
        this.updateObject((XPSObject)sAMLv1SP);
        Policy policy = sAMLv1SP.getPolicy();
        SAMLv1SPTest.assertFalse((String)"Policy is enabled", (boolean)policy.getIsEnabled());
    }

    @TestBase.STI(value=4)
    public void testUpdateAliasBackward() throws XPSException {
        Policy policy = sAMLv1SP.getPolicy();
        policy.setIsEnabled(Boolean.valueOf(true));
        this.updateObject((XPSObject)policy);
        InternalTesting.invalidate((XPSObject)sAMLv1SP);
        SAMLv1SPTest.assertTrue((String)"Affiliate is not enabled", (boolean)sAMLv1SP.getIsEnabled());
    }

    @TestBase.STI(value=5)
    public void testSAMLv1SPDeployment() {
        SAMLv1SPTest.skip("Raised RTC defect 138701 to see why this is consistently failing");
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)sAMLv1SP);
    }

    @TestBase.STI(value=6)
    public void testDeleteSAMLv1SP() throws XPSException {
        SAMLv1SPTest.skip("Raised RTC defect 138701 to see why this is consistently failing");
        this.deleteObject((XPSObject)sAMLv1SP);
        sAMLv1SP = null;
    }

    @TestBase.STI(value=7)
    public void testSAMLv1SPWithoutDomain() throws XPSException {
        String string = "SAMLv1SP1" + SetupConnection.random;
        sAMLv1SP = this.makeSAMLv1SP(string, null);
        this.failCreate((XPSObject)sAMLv1SP, "parent");
    }

    @TestBase.STI(value=8)
    public void testSAMLv1SPWithoutAuthURL() throws XPSException {
        String string = "SAMLv1SP" + SetupConnection.random;
        sAMLv1SP = this.makeSAMLv1SP(string, domain);
        sAMLv1SP.clearNetegrityAffiliateMinderAuthURL();
        this.failCreate((XPSObject)sAMLv1SP, "NetegrityAffiliateMinderAuthURL");
    }

    @TestBase.STI(value=9)
    public void testSAMLv1SPWithoutName() throws XPSException {
        sAMLv1SP = this.makeSAMLv1SP(null, domain);
        this.failCreate((XPSObject)sAMLv1SP, "Name");
    }

    private SAMLv1SP makeSAMLv1SP(String string, Domain domain) throws XPSException {
        SAMLv1SP sAMLv1SP = (SAMLv1SP)SetupConnection.policyData.newObject((IClass)SAMLv1SP.ddclass);
        if (string != null) {
            sAMLv1SP.setName(string);
        }
        if (domain != null) {
            sAMLv1SP.setParent(domain);
        }
        sAMLv1SP.setDSigningAlias("Testing");
        sAMLv1SP.setAllowNotification(Boolean.valueOf(true));
        sAMLv1SP.setAssertionPluginClass("Assertion");
        sAMLv1SP.setAssertionPluginParameters("AssertionParameter");
        sAMLv1SP.setConsumerURL("http://customer");
        sAMLv1SP.setDSigningAlias("DSigning");
        sAMLv1SP.setNetegrityAffiliateMinderAuthURL("http://AuthUrl");
        sAMLv1SP.setPassword("firewall");
        sAMLv1SP.setSAMLProfile("SAML Testing");
        sAMLv1SP.setSAMLMajorVersion(Integer.valueOf(2));
        sAMLv1SP.setSAMLMinorVersion(Integer.valueOf(0));
        sAMLv1SP.setSessionDriftPeriod("200");
        sAMLv1SP.setSessionSynchronization(Boolean.valueOf(false));
        sAMLv1SP.setSignAssertion(Boolean.valueOf(false));
        sAMLv1SP.setSkewTime(Integer.valueOf(30));
        sAMLv1SP.setValidityDuration(Integer.valueOf(60));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1.1.1.1");
        arrayList.add("2.2.2.2");
        sAMLv1SP.setIPAddresses(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("first");
        arrayList2.add("second");
        sAMLv1SP.setAttributeList(arrayList2);
        return sAMLv1SP;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SAMLv1SPTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SAMLv1SPTest.class);
    }
}

