/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.ResponseConstraint;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentTypeAttr;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ResponseConstraintTest
extends TestBase {
    static ResponseConstraint responseConstraint;
    static Response response;

    @TestBase.STI(value=1)
    public void testCreateResponseConstraint() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestResponseConstraintUserDir" + SetupConnection.random, "TestResponseConstraintAgent1" + SetupConnection.random, null, "TestResponseConstraintDomain" + SetupConnection.random, null, null, "TestResponseConstraintResponse" + SetupConnection.random, null);
        response = (Response)SetupConnection.fetchByName(Response.ddclass, "TestResponseConstraintResponse" + SetupConnection.random);
        responseConstraint = this.makeResponseConstraint(response);
        this.createObject((XPSObject)responseConstraint);
    }

    @TestBase.STI(value=2)
    public void testSearchResponseConstraint() throws XPSException {
        Filter filter = new Filter((IAttribute)ResponseConstraint.CONSTRAINT, Clause.Operator.EQUAL, (Object)"true");
        List list = SetupConnection.policyData.search((IClass)ResponseConstraint.ddclass, filter);
        ResponseConstraintTest.assertFalse((String)"policyData.search returned empty list", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateResponseConstraint() throws XPSException {
        responseConstraint.setConstraint("false");
        this.updateObject((XPSObject)responseConstraint);
    }

    @TestBase.STI(value=4)
    public void testResponseConstraintDeployment() throws XPSException {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)responseConstraint);
    }

    @TestBase.STI(value=5)
    public void testDeleteResponseConstraint() throws XPSException {
        this.deleteObject((XPSObject)responseConstraint);
        responseConstraint = null;
    }

    @TestBase.STI(value=6)
    public void testResponseConstraintWithoutResponse() throws XPSException {
        responseConstraint = this.makeResponseConstraint(null);
        this.failCreate((XPSObject)responseConstraint, "parent");
    }

    @TestBase.STI(value=7)
    public void testResponseWithoutAgentTypeAttr() throws XPSException {
        responseConstraint = this.makeResponseConstraint(response);
        responseConstraint.clearAgentTypeAttr();
        this.failCreate((XPSObject)responseConstraint, "AgentTypeAttrLink");
    }

    private ResponseConstraint makeResponseConstraint(Response response) throws XPSException {
        ResponseConstraint responseConstraint = (ResponseConstraint)SetupConnection.policyData.newObject((IClass)ResponseConstraint.ddclass);
        AgentTypeAttr agentTypeAttr = (AgentTypeAttr)SetupConnection.fetchByName(AgentTypeAttr.ddclass, "ServletAgent-HTTP-Cookie-Variable");
        if (response != null) {
            responseConstraint.setParent(response);
        }
        responseConstraint.setAgentTypeAttr(agentTypeAttr);
        responseConstraint.setConstraint("true");
        responseConstraint.setFlags(Integer.valueOf(0));
        responseConstraint.setTTL(Integer.valueOf(0));
        responseConstraint.setValue("testing" + SetupConnection.random);
        responseConstraint.setActiveExprString("ab = cd");
        return responseConstraint;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResponseConstraintTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ResponseConstraintTest.class);
    }
}

