/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.ODBCUserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.ODBCQuery;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ODBCUserDirectoryTest
extends TestBase {
    static ODBCUserDirectory oDBCUserDirectory;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateODBCUserDirectory() throws XPSException {
        this.doSetup();
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, "TestODBCUserDir" + SetupConnection.random);
        oDBCUserDirectory = this.makeODBCUserDirectory(userDir);
        this.createObject((XPSObject)oDBCUserDirectory);
    }

    @TestBase.STI(value=2)
    public void testSearchODBCUserDirectory() throws XPSException {
        Filter filter = new Filter((IAttribute)ODBCUserDirectory.POLICYSERVERNAME, Clause.Operator.EQUAL, (Object)"siteminder");
        Filter filter2 = new Filter((IAttribute)ODBCUserDirectory.POLL, Clause.Operator.EQUAL, (Object)2);
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)ODBCUserDirectory.ddclass, filter);
        ODBCUserDirectoryTest.assertFalse((String)"policyData.search returned empty list", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateODBCUserDirectory() throws XPSException {
        oDBCUserDirectory.setPoll(Integer.valueOf(1));
        this.updateObject((XPSObject)oDBCUserDirectory);
    }

    @TestBase.STI(value=4)
    public void testDeleteODBCUserDirectory() throws XPSException {
        this.deleteObject((XPSObject)oDBCUserDirectory);
        oDBCUserDirectory = null;
    }

    @TestBase.STI(value=5)
    public void testODBCUserDirectoryWithoutParent() throws XPSException {
        oDBCUserDirectory = this.makeODBCUserDirectory(null);
        this.failCreate((XPSObject)oDBCUserDirectory, "parent");
    }

    @TestBase.STI(value=6)
    public void testCreateODBCUserDirWithLDAP() throws XPSException {
        userDir = ObjectBuilder.doUserDirSetUp("TestLDAPUserDir" + SetupConnection.random);
        oDBCUserDirectory = this.makeODBCUserDirectory(userDir);
        this.failCreate((XPSObject)oDBCUserDirectory, "ODBC:");
    }

    private ODBCUserDirectory makeODBCUserDirectory(UserDirectory userDirectory) throws XPSException {
        ODBCUserDirectory oDBCUserDirectory = (ODBCUserDirectory)SetupConnection.policyData.newObject((IClass)ODBCUserDirectory.ddclass);
        if (userDirectory != null) {
            oDBCUserDirectory.setParent(userDirectory);
        }
        oDBCUserDirectory.setPolicyServerName("siteminder");
        oDBCUserDirectory.setTimeout(Integer.valueOf(60));
        oDBCUserDirectory.setPoll(Integer.valueOf(2));
        return oDBCUserDirectory;
    }

    private void doSetup() throws XPSException {
        this.doODBCQuerySetup();
        ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.fetchByName(ODBCQuery.ddclass, "testUserDirODBC" + SetupConnection.random);
        userDir = ObjectBuilder.makeUserDirectory("TestODBCUserDir" + SetupConnection.random);
        userDir.setNamespace("ODBC:");
        userDir.setODBCQuery(oDBCQuery);
        this.createObject((XPSObject)userDir);
    }

    private void doODBCQuerySetup() {
        ODBCQuery oDBCQuery = (ODBCQuery)SetupConnection.policyData.newObject((IClass)ODBCQuery.ddclass);
        oDBCQuery.setName("testUserDirODBC" + SetupConnection.random);
        this.createObject((XPSObject)oDBCQuery);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ODBCUserDirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ODBCUserDirectoryTest.class);
    }
}

