/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.epm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.epm.ApplicationGroup;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ApplicationGroupTest
extends TestBase {
    static ApplicationGroup applicationGroup;

    @TestBase.STI(value=1)
    public void testCreateApplicationGroup() throws XPSException {
        SetupConnection.builder.doApplicationSetUp("TestAppGroupUserDir" + SetupConnection.random, "TestAppGroupApp" + SetupConnection.random);
        String string = "ApplicationGroup" + SetupConnection.random;
        applicationGroup = this.makeApplicationGroup(string);
        this.createObject((XPSObject)applicationGroup);
    }

    @TestBase.STI(value=2)
    public void testSearchApplicationGroup() {
        SetupConnection.fetchByName(ApplicationGroup.ddclass, applicationGroup.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateApplicationGroup() throws XPSException {
        applicationGroup.setName("update" + applicationGroup.getName());
        applicationGroup.setDescription("update" + applicationGroup.getDescription());
        this.updateObject((XPSObject)applicationGroup);
    }

    @TestBase.STI(value=4)
    public void testApplicationGroupDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)applicationGroup);
    }

    @TestBase.STI(value=5)
    public void testDeleteApplicationGroup() throws XPSException {
        this.deleteObject((XPSObject)applicationGroup);
        applicationGroup = null;
    }

    @TestBase.STI(value=6)
    public void testApplicationGroupWithoutName() throws XPSException {
        applicationGroup = this.makeApplicationGroup(null);
        this.failCreate((XPSObject)applicationGroup, "Name");
    }

    @TestBase.STI(value=7)
    public void testApplicationGroupWithoutApplication() throws XPSException {
        String string = "ApplicationGroup2" + SetupConnection.random;
        applicationGroup = this.makeApplicationGroup(string);
        applicationGroup.clearApplications();
        this.createObject((XPSObject)applicationGroup);
    }

    private ApplicationGroup makeApplicationGroup(String string) throws XPSException {
        Filter filter = new Filter((IAttribute)Application.NAME, Clause.Operator.EQUAL, (Object)("TestAppGroupApp" + SetupConnection.random));
        List list = SetupConnection.policyData.search((IClass)Application.ddclass, filter);
        if (list.size() != 1) {
            throw new XPSException("getUserDirectories", new Object[]{list.getClass().getName(), string});
        }
        ApplicationGroup applicationGroup = (ApplicationGroup)SetupConnection.policyData.newObject((IClass)ApplicationGroup.ddclass);
        if (string != null) {
            applicationGroup.setName(string);
        }
        applicationGroup.setDescription("XPSAPI JUnit Sample ApplicationGroup");
        applicationGroup.setApplications(list);
        return applicationGroup;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ApplicationGroupTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ApplicationGroupTest.class);
    }
}

