/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.alias;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.alias.AliasBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DateAliasTest
extends AliasBase {
    @TestBase.STI(value=1)
    public void testDateAlias() throws XPSException {
        DateAliasTest.assertEquals((String)"Attribute AliasToDate must match with aliasedDate", (Object)gMainTest.getAliasToDate(), (Object)alisedDate);
    }

    @TestBase.STI(value=2)
    public void testDateAliasForward() throws XPSException {
        gMainTest.setAliasToDate(mainDate);
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        DateAliasTest.assertEquals((String)"The aliasTest::Date attribute must match with main date", (Object)test.getDate(), (Object)mainDate);
    }

    @TestBase.STI(value=3)
    public void testDateAliasBackward() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.setDate(mainDate);
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        DateAliasTest.assertEquals((String)"the gMainTest::AliasToDate attribute must match with main date", (Object)gMainTest.getAliasToDate(), (Object)mainDate);
    }

    @TestBase.STI(value=4)
    public void testDateAliasCleared() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        test.clearDate();
        this.updateObject((XPSObject)test);
        InternalTesting.invalidate((XPSObject)gMainTest);
        DateAliasTest.assertNull((String)"The AliasToDate attribute is not cleared", (Object)gMainTest.getAliasToDate());
    }

    @TestBase.STI(value=5)
    public void testDateMainCleared() throws XPSException {
        gMainTest.clearAliasToDate();
        this.updateObject((XPSObject)gMainTest);
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = gMainTest.getLink();
        InternalTesting.invalidate((XPSObject)test);
        DateAliasTest.assertNull((String)"The Date attribute is not cleared", (Object)test.getDate());
    }

    @TestBase.STI(value=6)
    public void testDateSetAliasBeforeLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(null);
        DateAliasTest.assertEquals((String)"Before setLink, the AliasToDate attribute must match with main date", (Object)test.getAliasToDate(), (Object)mainDate);
        test.setLink(test);
        this.updateObject((XPSObject)test);
        DateAliasTest.assertEquals((String)"After setLink, The AliasToDate attribute must match with aliased date", (Object)test.getAliasToDate(), (Object)alisedDate);
        test.clearLink();
        this.updateObject((XPSObject)test);
        DateAliasTest.assertEquals((String)"After clearLink, The AliasToDate attribute must match with main date", (Object)test.getAliasToDate(), (Object)mainDate);
    }

    @TestBase.STI(value=7)
    public void testDateWithoutLink() throws XPSException {
        DateAliasTest.assertEquals((String)"AliasToDateWithoutLink attribute must match with main date", (Object)gMainTest.getAliasToDateWithoutLink(), (Object)mainDate);
    }

    @TestBase.STI(value=8)
    public void testDateAliasToAliasLink() throws XPSException {
        com.ca.siteminder.sdk.adminapi.test.xps.Test test = this.createTest(this.createAliasTest());
        com.ca.siteminder.sdk.adminapi.test.xps.Test test2 = this.createTest(test);
        DateAliasTest.assertEquals((String)"AliasToAliasToDate attribute must match with aliased date", (Object)test2.getAliasToAliasToDate(), (Object)alisedDate);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DateAliasTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(DateAliasTest.class);
    }
}

