/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.AttributeMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Expression;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ApplicationSetup;
import com.ca.siteminder.sdk.adminapitest.CheckAuthentication;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseAuth;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleExpSetup
extends ApplicationSetup {
    public AuthSchemeType authSchemeType;
    public SetupType setupType;
    public String strGroupDN = null;
    protected String queryString = null;
    public CheckAuthentication checkAuth;
    public String currentExpression;

    public RoleExpSetup(TestSuite testSuite, AuthSchemeType authSchemeType, SetupType setupType) {
        super(testSuite);
        this.authSchemeType = authSchemeType;
        this.setupType = setupType;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz, AuthSchemeType authSchemeType, SetupType setupType, String string) {
        this(clazz, authSchemeType, setupType);
        this.queryString = string;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz, AuthSchemeType authSchemeType, SetupType setupType) {
        super(clazz);
        this.authSchemeType = authSchemeType;
        this.setupType = setupType;
    }

    public RoleExpSetup(Class<? extends TestBase> clazz) {
        this(clazz, AuthSchemeType.Basic, SetupType.Basic);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.doSetup();
        TestBaseAuth.expSetup = this;
    }

    @Override
    public void tearDown() {
        this.checkAuth.logout();
        super.tearDown();
    }

    protected void SetGroupPaths() {
        Object var1_1 = null;
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (string.equals("ODBC:")) {
            this.strGroupDN = "ExprGroup";
        } else if (string.equals("LDAP:") || string.equals("AD:")) {
            String string2 = SetupConnection.properties.get("LDAP_SEARCH_ROOT");
            String string3 = SetupConnection.properties.get("LDAP_GROUP_SEARCH_ATTR1");
            String string4 = SetupConnection.properties.get("LDAP_GROUP_ATTR");
            this.strGroupDN = string4 + "=ExprGroup," + string3 + "=Groups," + string2;
        }
    }

    public void doSetup() throws XPSException {
        String string;
        if (this.setupType == SetupType.RiskSetup) {
            SetupConnection.configSM.setValue("ConfidenceLevelSupportEnabled", "true");
            this.updateRealm(this.strAppName, null, true);
            string = "(INTEGER (SM_USER_CONFIDENCE_LEVEL) >= INTEGER (SM_MIN_CONFIDENCE_LEVEL))";
            this.updateRole(this.strRoleName, string);
        }
        string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        this.SetGroupPaths();
        this.createAttributeMapping("IsPremiumUser", AttributeMapping.Type.Group, this.strGroupDN);
        this.createAttributeMapping("IsUser", AttributeMapping.Type.Constant, "TRUE");
        this.createAttributeMapping("IsBoss", AttributeMapping.Type.Expression, "(telephoneNumber CONTAINS \"6666\")");
        this.createAttributeMapping("IsPeon", AttributeMapping.Type.Expression, "(NOT (telephoneNumber CONTAINS \"6666\"))");
        if (string.equals("ODBC:")) {
            this.createAttributeMapping("CarLicensePlusFive", AttributeMapping.Type.Expression, "(NUMBER(Disabled) + 5)");
            this.createAttributeMapping("CarLicenseBasedString", AttributeMapping.Type.Expression, "(\"1234\" + Disabled)");
        } else {
            this.createAttributeMapping("CarLicensePlusFive", AttributeMapping.Type.Expression, "(NUMBER(carLicense) + 5)");
            this.createAttributeMapping("CarLicenseBasedString", AttributeMapping.Type.Expression, "(\"1234\" + carLicense)");
        }
        this.login(this.queryString);
    }

    public void login() {
        this.login(null);
    }

    public void setQueryString(String string) {
        this.login(string);
    }

    void login(String string) {
        this.strAgentName = "Agent" + this.getAppendStr();
        String string2 = SetupConnection.properties.get("PS_IP");
        this.checkAuth = new CheckAuthentication(string2, this.strAgentName);
        String string3 = "ExprTestUser";
        if (!this.checkAuth.isProtected(string)) {
            RoleExpSetup.fail((String)"Resource must be protected");
        }
        if (!this.checkAuth.isAuthenticated(string3, "firewall")) {
            RoleExpSetup.fail((String)("Authentication of user '" + string3 + "' failed"));
        }
    }

    public boolean isProtected(String string) {
        return this.checkAuth.isProtected(string);
    }

    public void createAttributeMapping(String string, AttributeMapping.Type type, String string2) {
        UserDirectory userDirectory = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, this.strUDName);
        AttributeMapping attributeMapping = (AttributeMapping)SetupConnection.policyData.newObject((IClass)AttributeMapping.ddclass);
        attributeMapping.setParent(userDirectory);
        attributeMapping.setName(string);
        attributeMapping.setType(type);
        attributeMapping.setDefinition(string2);
        this.createRoleObject((XPSObject)attributeMapping);
    }

    public void updateRole(String string) throws XPSException {
        this.currentExpression = string;
        this.updateRole(this.strRoleName, string);
    }

    public void createExpression(String string, String string2) throws XPSException {
        Expression expression = (Expression)SetupConnection.policyData.newObject((IClass)Expression.ddclass);
        expression.setName(string);
        expression.setDescription("XPSAPI JUnit Sample Expression");
        expression.setExpression(string2);
        this.createRoleObject((XPSObject)expression);
    }

    public void createOrModifyExpression(String string, String string2) throws XPSException {
        Expression expression = null;
        try {
            expression = (Expression)SetupConnection.fetchByName(Expression.ddclass, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (expression == null) {
            this.createExpression(string, string2);
        } else {
            expression.setName(string);
            expression.setDescription("XPSAPI JUnit Sample Expression");
            expression.setExpression(string2);
            this.updateRoleObject((XPSObject)expression);
        }
    }

    public void createAuthSchemeHTML(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauththtml");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.HTMLForm);
            authScheme.setParam("http://" + SetupConnection.properties.get("CLIENT_HOST_NAME") + ":" + SetupConnection.properties.get("CLIENT_PORT") + "/siteminderagent/forms/login.fcc;ACS=0;REL=0");
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    public void createAuthSchemeTest(String string) throws XPSException {
        if (string != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.policyData.newObject((IClass)AuthScheme.ddclass);
            authScheme.setName(string);
            authScheme.setDesc("XPSAPI JUnit Sample AuthScheme");
            authScheme.setLevel(Integer.valueOf(5));
            authScheme.setLibrary("smauthtest");
            authScheme.setIsUsedbyAdmin(Boolean.valueOf(false));
            authScheme.setType(AuthScheme.Type.Custom);
            this.createRoleObject((XPSObject)authScheme);
        }
    }

    public void updateRealm(String string, String string2, boolean bl) {
        Realm realm = (Realm)SetupConnection.fetchByName(Realm.ddclass, string);
        if (string2 != null) {
            AuthScheme authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, string2);
            realm.setAuthScheme(authScheme);
        }
        if (bl) {
            realm.setMinUserConfidenceLevel(Integer.valueOf(300));
        }
        SetupConnection.updateObject((XPSObject)realm);
    }

    public void updateRealm(String string, boolean bl) {
        this.updateRealm(this.strAppName, string, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetupType {
        Basic,
        RiskSetup;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthSchemeType {
        Basic,
        FormAuthScheme,
        CustomAuthScheme;

    }
}

