/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.sdk.policyapi;

import com.netegrity.sdk.policyapi.SmAdmin;
import com.netegrity.sdk.policyapi.SmAgent;
import com.netegrity.sdk.policyapi.SmAgentGroup;
import com.netegrity.sdk.policyapi.SmAgentType;
import com.netegrity.sdk.policyapi.SmAgentTypeAttr;
import com.netegrity.sdk.policyapi.SmAuthAzMap;
import com.netegrity.sdk.policyapi.SmCertMap;
import com.netegrity.sdk.policyapi.SmDomain;
import com.netegrity.sdk.policyapi.SmODBCQuery;
import com.netegrity.sdk.policyapi.SmObject;
import com.netegrity.sdk.policyapi.SmPasswordPolicy;
import com.netegrity.sdk.policyapi.SmPolicy;
import com.netegrity.sdk.policyapi.SmPolicyLink;
import com.netegrity.sdk.policyapi.SmPwdPolicyRegularExpression;
import com.netegrity.sdk.policyapi.SmRealm;
import com.netegrity.sdk.policyapi.SmResponse;
import com.netegrity.sdk.policyapi.SmResponseAttr;
import com.netegrity.sdk.policyapi.SmResponseGroup;
import com.netegrity.sdk.policyapi.SmRootConfig;
import com.netegrity.sdk.policyapi.SmRule;
import com.netegrity.sdk.policyapi.SmRuleGroup;
import com.netegrity.sdk.policyapi.SmScheme;
import com.netegrity.sdk.policyapi.SmSelfReg;
import com.netegrity.sdk.policyapi.SmTrustedHost;
import com.netegrity.sdk.policyapi.SmUserDirectory;
import com.netegrity.sdk.policyapi.SmUserPolicy;
import com.netegrity.sdk.policyapi.SmVariable;
import com.netegrity.sdk.policyapi.SmVariableType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class SmObjId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern OID_PATTERN = Pattern.compile("(?:[0-9a-fA-F]{2}\\-[0-9a-fA-F]{8}\\-(?:[0-9a-fA-F]{4}\\-){3}[0-9a-fA-F]{11}[0-9a-hA-H])|(?:00\\-)");
    public static final SmObjId NULL_OID;
    public static final SmObjId SmNullOid;
    private static final Map objectClassMap;
    private String oid;
    private Integer objectType;

    public static String getObjectClass(String string) {
        return SmObjId.valueOf(string).getObjectClass();
    }

    public static SmObjId valueOf(String string) {
        return new SmObjId(string);
    }

    public SmObjId() {
        this(SmObjId.NULL_OID.oid);
    }

    public SmObjId(Object object) {
        this(object.toString());
    }

    public SmObjId(SmObject smObject) {
        this(smObject.getOid().toString());
    }

    private SmObjId(String string) {
        this.oid = string;
        this.objectType = OID_PATTERN.matcher(string).matches() ? Integer.valueOf(string.substring(0, 2), 16) : new Integer(-1);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SmObjId)) {
            return false;
        }
        SmObjId smObjId = (SmObjId)object;
        if (this.isNull()) {
            return smObjId.isNull();
        }
        if (smObjId.isNull()) {
            return this.isNull();
        }
        return this.oid.equals(smObjId.oid);
    }

    public String getObjectClass() {
        Class clazz = (Class)objectClassMap.get(this.objectType);
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n < 0 ? string : string.substring(n + 1);
    }

    public String getOidString() {
        return this.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return SmObjId.NULL_OID.oid.hashCode();
        }
        return this.oid.hashCode();
    }

    public boolean isNull() {
        return this.objectType == 0;
    }

    public boolean isValid() {
        return this.objectType != -1;
    }

    public void setOid(String string) {
        this.oid = string;
        this.objectType = OID_PATTERN.matcher(string).matches() ? Integer.valueOf(string.substring(0, 2), 16) : new Integer(-1);
    }

    public String toString() {
        if (this.isNull()) {
            return SmObjId.NULL_OID.oid;
        }
        return this.oid;
    }

    static {
        SmNullOid = NULL_OID = SmObjId.valueOf("00-");
        objectClassMap = new HashMap();
        objectClassMap.put(new Integer(1), SmAgent.class);
        objectClassMap.put(new Integer(2), SmAgentGroup.class);
        objectClassMap.put(new Integer(3), SmDomain.class);
        objectClassMap.put(new Integer(4), SmPolicy.class);
        objectClassMap.put(new Integer(5), SmPolicyLink.class);
        objectClassMap.put(new Integer(6), SmRealm.class);
        objectClassMap.put(new Integer(7), SmResponse.class);
        objectClassMap.put(new Integer(8), SmResponseAttr.class);
        objectClassMap.put(new Integer(9), SmResponseGroup.class);
        objectClassMap.put(new Integer(11), SmRule.class);
        objectClassMap.put(new Integer(12), SmRuleGroup.class);
        objectClassMap.put(new Integer(13), SmScheme.class);
        objectClassMap.put(new Integer(14), SmUserDirectory.class);
        objectClassMap.put(new Integer(15), SmUserPolicy.class);
        objectClassMap.put(new Integer(16), SmAgentType.class);
        objectClassMap.put(new Integer(17), SmAgentTypeAttr.class);
        objectClassMap.put(new Integer(18), SmAdmin.class);
        objectClassMap.put(new Integer(21), SmAuthAzMap.class);
        objectClassMap.put(new Integer(22), SmCertMap.class);
        objectClassMap.put(new Integer(23), SmSelfReg.class);
        objectClassMap.put(new Integer(24), SmODBCQuery.class);
        objectClassMap.put(new Integer(25), SmPasswordPolicy.class);
        objectClassMap.put(new Integer(28), SmRootConfig.class);
        objectClassMap.put(new Integer(29), SmVariable.class);
        objectClassMap.put(new Integer(30), SmVariableType.class);
        objectClassMap.put(new Integer(35), SmPwdPolicyRegularExpression.class);
        objectClassMap.put(new Integer(36), SmTrustedHost.class);
    }
}

