/*
 * Decompiled with CFR 0.152.
 */
package netegrity.siteminder.javaagent;

import java.util.Vector;
import netegrity.siteminder.javaagent.ServerDef;

public class InitDef {
    public static final int FIPS140_COMPAT = 0;
    public static final int FIPS140_ONLY = 1;
    public static final int CRYPTO_OP_UNSET = 0;
    public static final int CRYPTO_OP_COMPAT = 1;
    public static final int CRYPTO_OP_MIGRATE_F1402 = 2;
    public static final int CRYPTO_OP_F1402 = 3;
    public static final int CRYPTO_OP_F1402MD5 = 4;
    protected Vector m_servers = new Vector();
    protected String m_hostName = "";
    protected String m_sharedSecret = "";
    protected boolean m_failOver = false;
    protected int m_failOverThreshold = -1;
    protected String m_configFileName = null;
    protected int m_FIPSMode = 0;

    public InitDef() {
        this.m_servers = new Vector();
        this.m_hostName = "";
        this.m_sharedSecret = "";
        this.m_failOver = false;
    }

    public InitDef(String hostName, String sharedSecret, boolean failOver, ServerDef sd) {
        this.m_hostName = hostName;
        this.m_sharedSecret = sharedSecret;
        this.m_failOver = failOver;
        this.m_failOverThreshold = -1;
        this.m_servers = new Vector();
        this.m_servers.addElement(sd);
    }

    public InitDef(String hostName, String sharedSecret, int failOverThreshold, ServerDef sd) {
        this.m_hostName = hostName;
        this.m_sharedSecret = sharedSecret;
        this.m_failOver = false;
        this.m_failOverThreshold = failOverThreshold;
        this.m_servers = new Vector();
        this.m_servers.addElement(sd);
    }

    public void addServerDef(ServerDef sd) {
        this.m_servers.addElement(sd);
    }

    public void addServerDef(String serverIpAddress, int connectionMin, int connectionMax, int connectionStep, int timeout, int authorizationPort, int authenticationPort, int accountingPort, int clusterSeq) {
        ServerDef sd = new ServerDef();
        sd.serverIpAddress = serverIpAddress;
        sd.connectionMin = connectionMin;
        sd.connectionMax = connectionMax;
        sd.connectionStep = connectionStep;
        sd.timeout = timeout;
        sd.authorizationPort = authorizationPort;
        sd.authenticationPort = authenticationPort;
        sd.accountingPort = accountingPort;
        sd.clusterSeq = clusterSeq;
        this.m_servers.addElement(sd);
    }

    public void addServerDef(String serverIpAddress, int connectionMin, int connectionMax, int connectionStep, int timeout, int authorizationPort, int authenticationPort, int accountingPort) {
        this.addServerDef(serverIpAddress, connectionMin, connectionMax, connectionStep, timeout, authorizationPort, authenticationPort, accountingPort, 0);
    }

    public int getServerCount() {
        return this.m_servers.size();
    }

    public ServerDef getServerAt(int index) {
        return (ServerDef)this.m_servers.elementAt(index);
    }

    public Vector getServers() {
        return this.m_servers;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public String getSharedSecret() {
        return this.m_sharedSecret;
    }

    public boolean isFailOver() {
        return this.m_failOver;
    }

    public int failOverThreshold() {
        return this.m_failOverThreshold;
    }

    void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    void setSharedSecret(String sharedSecret) {
        this.m_sharedSecret = sharedSecret;
    }

    void setFailOver(boolean failOver) {
        this.m_failOver = failOver;
    }

    void setFailOverThreshold(int failOverThreshold) {
        this.m_failOverThreshold = failOverThreshold;
    }

    String getConfigFileName() {
        return this.m_configFileName;
    }

    void setConfigFileName(String configFileName) {
        this.m_configFileName = configFileName;
    }

    public void setCryptoOpMode(int cryptoOpMode) {
        this.m_FIPSMode = cryptoOpMode;
    }

    public int getCryptoOpMode() {
        return this.m_FIPSMode;
    }

    public void setFIPSMode(int fipsMode) {
        if (0 == fipsMode) {
            this.m_FIPSMode = 1;
        } else if (1 == fipsMode) {
            this.m_FIPSMode = 2;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public int getFIPSMode() {
        if (1 == this.m_FIPSMode || 0 == this.m_FIPSMode) {
            return 0;
        }
        return 1;
    }
}

