/*
 * Decompiled with CFR 0.152.
 */
package netegrity.siteminder.javaagent;

import com.ca.siteminder.sdk.agentapi.LegacyAgentApi;
import com.ca.siteminder.sdk.agentapi.LegacyAgentApiAdapter;
import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiImpl;
import com.ca.siteminder.sdk.agentapi.SmAttribute;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigAttribute;
import com.ca.siteminder.sdk.agentapi.connection.SmInitDef;
import com.ca.siteminder.sdk.agentapi.management.SmAgentApiManagementResult;
import com.netegrity.util.Fips140Mode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import netegrity.siteminder.javaagent.AgentInstanceDef;
import netegrity.siteminder.javaagent.AttributeList;
import netegrity.siteminder.javaagent.BinaryBuffer;
import netegrity.siteminder.javaagent.InitDef;
import netegrity.siteminder.javaagent.ManagementContextDef;
import netegrity.siteminder.javaagent.RealmDef;
import netegrity.siteminder.javaagent.ResourceContextDef;
import netegrity.siteminder.javaagent.ServerDef;
import netegrity.siteminder.javaagent.SessionDef;
import netegrity.siteminder.javaagent.TokenDescriptor;
import netegrity.siteminder.javaagent.TunnelServiceRequest;
import netegrity.siteminder.javaagent.UserCredentials;

public class AgentAPI
implements LegacyAgentApi,
SmAgentApiConstants {
    public static final int VERSION_40 = 1024;
    public static final int VERSION_50 = 1280;
    public static final int VERSION_60 = 1536;
    public static final int VERSION_60_FIPS = 1542;
    public static final int VERSION_12 = 3072;
    public static final int VERSION_12_5 = 3152;
    public static final int INVALID_AGENTINSTANCEDEF = -58;
    public static final int INVALID_SESSIONID = -57;
    public static final int INVALID_MGMTCTXDEF = -56;
    public static final int INVALID_ATTRLIST = -55;
    public static final int INVALID_TSR = -54;
    public static final int INVALID_SESSIONDEF = -53;
    public static final int INVALID_USERCREDS = -52;
    public static final int INVALID_REALMDEF = -51;
    public static final int INVALID_RESCTXDEF = -50;
    public static final int INVALID_AUTHDOMAIN = -49;
    public static final int INVALID_AUTHSCHEME = -48;
    public static final int NOCONNECTION = -3;
    public static final int TIMEOUT = -2;
    public static final int FAILURE = -1;
    public static final int SUCCESS = 0;
    public static final int YES = 1;
    public static final int NO = 2;
    public static final int CHALLENGE = 3;
    public static final int UNRESOLVED = 4;
    public static final int CRED_NONE = 0;
    public static final int CRED_BASIC = 1;
    public static final int CRED_DIGEST = 2;
    public static final int CRED_X509CERT = 4;
    public static final int CRED_X509CERT_USERDN = 8;
    public static final int CRED_X509CERT_ISSUERDN = 16;
    public static final int CRED_CERT_OR_BASIC = 32;
    public static final int CRED_NT_CHAL_RESP = 64;
    public static final int CRED_CERT_OR_FORM = 128;
    public static final int CRED_XML_DOCUMENT_MAPPED = 256;
    public static final int CRED_XML_DSIG = 512;
    public static final int CRED_XML_DSIG_XKMS = 1024;
    public static final int CRED_SAML = 2048;
    public static final int CRED_XML_WSSEC = 8192;
    public static final int CRED_SSLREQUIRED = 0x1000000;
    public static final int CRED_FORMREQUIRED = 0x2000000;
    public static final int CRED_ALLOWSAVECREDS = 0x4000000;
    public static final int CRED_METADATA_REQUIRED = 0x20000000;
    public static final int ATTR_AUTH_DIR_NAME = 213;
    public static final int ATTR_AUTH_DIR_SERVER = 214;
    public static final int ATTR_AUTH_DIR_NAMESPACE = 215;
    public static final int ATTR_USERMSG = 216;
    public static final int ATTR_USERDN = 218;
    public static final int ATTR_AUTH_DIR_OID = 151;
    public static final int ATTR_USERUNIVERSALID = 152;
    public static final int ATTR_IDENTITYSPEC = 156;
    public static final int ATTR_STARTSESSIONTIME = 154;
    public static final int ATTR_LASTSESSIONTIME = 155;
    public static final int ATTR_DEVICENAME = 200;
    public static final int ATTR_SESSIONID = 205;
    public static final int ATTR_CLIENTIP = 208;
    public static final int ATTR_SESSIONSPEC = 209;
    public static final int ATTR_USERNAME = 210;
    public static final int ATTR_IDLESESSIONTIMEOUT = 225;
    public static final int ATTR_MAXSESSIONTIMEOUT = 226;
    public static final int AFFILIATE_KEY_UPDATE = 189;
    public static final int AGENT_KEY_UPDATE_NEXT = 190;
    public static final int AGENT_KEY_UPDATE_LAST = 191;
    public static final int AGENT_KEY_UPDATE_CURRENT = 192;
    public static final int AGENT_KEY_UPDATE_PERSISTENT = 193;
    public static final int CACHE_FLUSH_ALL = 194;
    public static final int CACHE_FLUSH_ALL_USERS = 195;
    public static final int CACHE_FLUSH_THIS_USER = 196;
    public static final int CACHE_FLUSH_ALL_REALMS = 197;
    public static final int CACHE_FLUSH_THIS_REALM = 198;
    public static final int ATTR_STATUS_MESSAGE = 158;
    public static final int ATTR_SERVICE_DATA = 164;
    public static final int CERT_HASH_SIZE = 20;
    public static final int AZ_SERVER = 0;
    public static final int AUTH_SERVER = 1;
    public static final int ACCT_SERVER = 2;
    private static final String CLASS_NAME = AgentAPI.class.getName();
    private static final String CLUSTER_PREFIX = "cluster_";
    private static final String THRESHOLD_ATTRIBUTE = "threshold";
    private static final String WINDOWS_PLATFORM = "Windows";
    private static final String CLUSTER_SERVER_SEPARATOR = "&";
    protected LegacyAgentApiAdapter m_adapter = new LegacyAgentApiAdapter();

    public int init(InitDef initDef) {
        if (initDef == null) {
            return this.m_adapter.init(null);
        }
        if (0 == initDef.getCryptoOpMode()) {
            initDef.setCryptoOpMode(Util.resolveSetting());
        }
        return this.m_adapter.init(initDef, initDef.getConfigFileName());
    }

    public int unInit() {
        return this.m_adapter.unInit();
    }

    public int isProtected(String clientIpAddress, ResourceContextDef rcd, RealmDef rd) {
        return this.m_adapter.isProtected(clientIpAddress, rcd, rd);
    }

    public int isProtectedEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, String transactionId) {
        return this.m_adapter.isProtectedEx(clientIpAddress, rcd, rd, transactionId);
    }

    public int isProtectedDLP(String clientIpAddress, ResourceContextDef rcd, RealmDef rd) {
        return this.m_adapter.isProtectedDLP(clientIpAddress, rcd, rd);
    }

    public int isProtectedDLPEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, String transactionId) {
        return this.m_adapter.isProtectedDLPEx(clientIpAddress, rcd, rd, transactionId);
    }

    public int login(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al) {
        return this.m_adapter.login(clientIpAddress, rcd, rd, uc, sd, al);
    }

    public int loginEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al, String transactionId) {
        return this.m_adapter.loginEx(clientIpAddress, rcd, rd, uc, sd, al, transactionId);
    }

    public int validate(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al) {
        return this.m_adapter.validate(clientIpAddress, rcd, rd, uc, sd, al);
    }

    public int validateEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al, String transactionId) {
        return this.m_adapter.validateEx(clientIpAddress, rcd, rd, uc, sd, al, transactionId);
    }

    public int validateServiceToken(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al) {
        return this.m_adapter.validateServiceToken(clientIpAddress, rcd, rd, uc, sd, al);
    }

    public int validateServiceTokenEx(String clientIpAddress, ResourceContextDef rcd, RealmDef rd, UserCredentials uc, SessionDef sd, AttributeList al, String transactionId) {
        return this.m_adapter.validateServiceTokenEx(clientIpAddress, rcd, rd, uc, sd, al, transactionId);
    }

    public int authorize(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al) {
        return this.m_adapter.authorize(clientIpAddress, transactionId, rcd, rd, sd, al);
    }

    public int authorizeEx(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al, StringBuffer UnresolvedList, StringBuffer ResolvedList, Boolean bSimpleAuth) {
        return this.m_adapter.authorizeEx(clientIpAddress, transactionId, rcd, rd, sd, al, UnresolvedList, ResolvedList, bSimpleAuth);
    }

    public int authorizeDLP(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al) {
        return this.m_adapter.authorizeDLP(clientIpAddress, transactionId, rcd, rd, sd, al);
    }

    public int authorizeDLPEx(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList al, StringBuffer UnresolvedList, StringBuffer ResolvedList, Boolean bSimpleAuth) {
        return this.m_adapter.authorizeDLPEx(clientIpAddress, transactionId, rcd, rd, sd, al, UnresolvedList, ResolvedList, bSimpleAuth);
    }

    public int logout(String clientIpAddress, SessionDef sd) {
        return this.m_adapter.logout(clientIpAddress, sd);
    }

    public int logoutEx(String clientIpAddress, SessionDef sd, String transactionId) {
        return this.m_adapter.logoutEx(clientIpAddress, sd, transactionId);
    }

    public int audit(String clientIpAddress, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd) {
        return this.m_adapter.audit(clientIpAddress, transactionId, rcd, rd, sd);
    }

    public int doManagement(ManagementContextDef mc, AttributeList al) {
        return this.m_adapter.doManagement(mc, al);
    }

    public int setAgentInstanceInfo(AgentInstanceDef agentInstanceDef) {
        return this.m_adapter.setAgentInstanceInfo(agentInstanceDef);
    }

    public int updateAttributes(String clientIpAddr, String transactionId, ResourceContextDef rcd, RealmDef rd, SessionDef sd, AttributeList requestAttrs, AttributeList responseAttrs) {
        return this.m_adapter.updateAttributes(clientIpAddr, transactionId, rcd, rd, sd, requestAttrs, responseAttrs);
    }

    private Map parseHostConfigAttributes(List smAttributes) throws UnsupportedEncodingException {
        String methodName = "parseHostConfigAttributes";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Parsing total attributes = " + smAttributes.size());
        }
        LinkedHashMap<String, Object> parsedAttributes = new LinkedHashMap<String, Object>((int)Math.ceil((double)smAttributes.size() * 1.35));
        int clusterThreshold = -1;
        Iterator iterator = smAttributes.iterator();
        while (iterator.hasNext()) {
            SmAttribute smAttribute = (SmAttribute)iterator.next();
            if (smAttribute != null & smAttribute.getId() == 144 && smAttribute.getValue() != null) {
                int index;
                String value = new String(smAttribute.getValue(), "UTF-8");
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Processing TLI config attribute id = " + smAttribute.getId() + ", value = " + value);
                }
                if ((index = value.indexOf(61)) <= 0) continue;
                String name = value.substring(0, index).trim().toLowerCase();
                value = value.substring(index + 1);
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Processing hostConfig name = " + name + ", value = " + value);
                }
                if (value == null) continue;
                if (name.startsWith(CLUSTER_PREFIX)) {
                    int clusterIndex = Integer.parseInt(name.substring(CLUSTER_PREFIX.length()));
                    int totalClusterServers = Integer.parseInt(value);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Processing cluster# = " + clusterIndex + ", total servers = " + totalClusterServers);
                    }
                    StringBuffer clusterServerList = new StringBuffer();
                    for (int k = 0; k < totalClusterServers && iterator.hasNext(); ++k) {
                        SmAttribute next = (SmAttribute)iterator.next();
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Processing expected server attribute: " + next);
                        }
                        if (next.getValue() == null) continue;
                        String serverValue = new String(next.getValue(), "UTF-8");
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Processing server = " + serverValue);
                        }
                        clusterServerList.append(serverValue);
                        clusterServerList.append(CLUSTER_SERVER_SEPARATOR);
                    }
                    String parsedValue = clusterServerList.toString().substring(0, clusterServerList.length() - 1);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Inserting cluster to parsedAttribute list: " + parsedValue);
                    }
                    parsedAttributes.put(CLUSTER_PREFIX + clusterIndex, parsedValue);
                    if (!iterator.hasNext()) continue;
                    SmAttribute thresholdAttribute = (SmAttribute)iterator.next();
                    if (clusterThreshold >= 0 || thresholdAttribute.getValue() == null || thresholdAttribute.getId() != 144) continue;
                    String thresholdValue = new String(thresholdAttribute.getValue(), "UTF-8");
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Received threshhold attribute = " + thresholdValue);
                    }
                    clusterThreshold = (int)Float.parseFloat(thresholdValue);
                    continue;
                }
                if (!name.equals(SM_CONF_POLICY_SERVER.getName())) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Inserting to parsedAttributes single-value name = " + name + ", value = " + value);
                    }
                    parsedAttributes.put(name, value);
                    continue;
                }
                ArrayList<String> policyServers = (ArrayList<String>)parsedAttributes.get(name);
                if (policyServers == null) {
                    policyServers = new ArrayList<String>();
                }
                policyServers.add(value);
                parsedAttributes.put(name, policyServers);
                if (!Util.isLogEnabled()) continue;
                Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Inserting to parsedAttributes policyserver = " + value + ", currentListSize = " + policyServers.size());
                continue;
            }
            if (smAttribute == null || !Util.isLogEnabled()) continue;
            Util.display(5, CLASS_NAME, "parseHostConfigAttributes", "Ignoring non-TLI config attribute id = " + smAttribute.getId() + ", value = " + new String(smAttribute.getValue(), "UTF-8"));
        }
        if (clusterThreshold >= 0) {
            parsedAttributes.put(THRESHOLD_ATTRIBUTE, String.valueOf(clusterThreshold));
        }
        return parsedAttributes;
    }

    /*
     * Loose catch block
     */
    private Map loadHostConfigAttributes(Map initDefConfig) throws SmAgentApiException {
        Map parsedAttributes;
        SmAgentApiManagementResult result;
        block12: {
            String methodName = "loadHostConfigAttributes";
            SmInitDef smInitDef = Util.createSmInitDef(initDefConfig, null);
            SmAgentApiImpl handle = new SmAgentApiImpl();
            result = null;
            Util.display(5, CLASS_NAME, "loadHostConfigAttributes", "About to call SmAgentApiImpl.init()");
            handle.init(smInitDef);
            result = handle.getHostConfig((String)initDefConfig.get(SM_CONF_HOSTCONFIG.getName()));
            Object var8_6 = null;
            try {
                handle.close();
            }
            catch (SmAgentApiException e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "loadHostConfigAttributes", "Failed to close the connection from bootstrapping");
                    e.printStackTrace();
                }
                break block12;
            }
            {
                catch (SmAgentApiException e) {
                    throw e;
                }
            }
            catch (Throwable throwable) {
                block13: {
                    Object var8_7 = null;
                    try {
                        handle.close();
                    }
                    catch (SmAgentApiException e) {
                        if (!Util.isLogEnabled()) break block13;
                        Util.display(2, CLASS_NAME, "loadHostConfigAttributes", "Failed to close the connection from bootstrapping");
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        if (result == null) {
            Util.display(2, CLASS_NAME, "loadHostConfigAttributes", "No hostconfig object results");
            throw new SmAgentApiException("No bootstrapping hostconfig object result");
        }
        List attributes = result.getAttributeList();
        if (attributes == null) {
            Util.display(2, CLASS_NAME, "loadHostConfigAttributes", "No hostconfig object result attributes");
            throw new SmAgentApiException("No bootstrapping hostconfig object result attributes");
        }
        try {
            parsedAttributes = this.parseHostConfigAttributes(result.getAttributeList());
        }
        catch (UnsupportedEncodingException e) {
            throw new SmAgentApiException(e);
        }
        return parsedAttributes;
    }

    public int getConfig(InitDef initDef, String passed4xAgentName, String configPath) {
        String methodName = "getConfig";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "getConfig", "Started: configPath = " + configPath);
        }
        if (initDef == null) {
            Util.display(2, CLASS_NAME, "getConfig", "Null argument passed");
            return -1;
        }
        boolean foundPath = true;
        if (configPath == null) {
            String osName = System.getProperty("os.name");
            if (osName != null && osName.startsWith(WINDOWS_PLATFORM)) {
                boolean foundAgent = false;
                foundPath = false;
                String pathRegName = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "configfile");
                if (pathRegName != null && pathRegName.length() != 0) {
                    configPath = pathRegName;
                    foundPath = true;
                }
                if (!foundPath) {
                    if (passed4xAgentName != null && passed4xAgentName.length() != 0) {
                        String HostRegName = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "agentnamelist");
                        String waRegName = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "defaultagentname");
                        if (waRegName != null && waRegName.length() != 0) {
                            if (waRegName.indexOf(44) >= 0) {
                                StringTokenizer waList = new StringTokenizer(waRegName, ",");
                                while (waList.hasMoreTokens()) {
                                    if (waList.nextToken() == null || !waList.nextToken().equals(passed4xAgentName)) continue;
                                    foundAgent = true;
                                    initDef.setHostName(HostRegName);
                                }
                            } else if (waRegName.equals(passed4xAgentName)) {
                                foundAgent = true;
                                initDef.setHostName(HostRegName);
                            }
                        }
                        if (!foundAgent) {
                            return -1;
                        }
                    } else {
                        String waDefaultName = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "defaultagentname");
                        if (waDefaultName != null && waDefaultName.length() != 0) {
                            initDef.setHostName(waDefaultName);
                        } else {
                            return -1;
                        }
                    }
                    boolean failOver = false;
                    String failOverStr = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "enablefailover");
                    if (failOverStr == null || failOverStr.length() == 0) {
                        return -1;
                    }
                    failOver = Util.isTrueOrYes(failOverStr);
                    initDef.setFailOver(failOver);
                    String sharedSecret = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "sharedsecret");
                    if (sharedSecret == null || sharedSecret.length() == 0) {
                        return -1;
                    }
                    initDef.setSharedSecret(sharedSecret);
                    List serverList = null;
                    ArrayList<String> psList = new ArrayList<String>();
                    String policyServerList = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "policyserverlist");
                    if (policyServerList == null || policyServerList.length() == 0) {
                        return -1;
                    }
                    psList.add(policyServerList);
                    serverList = this.createPolicyServerClusterList(psList, failOver);
                    String reqTimeOut = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "requesttimeout");
                    if (reqTimeOut == null && reqTimeOut.length() == 0) {
                        return -1;
                    }
                    String minSocketPerPort = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "minsocketsperport");
                    if (minSocketPerPort == null && minSocketPerPort.length() == 0) {
                        return -1;
                    }
                    String maxSocketPerPort = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "maxsocketsperport");
                    if (maxSocketPerPort == null && maxSocketPerPort.length() == 0) {
                        return -1;
                    }
                    String newSocketStep = Util.getValueFromRegistry("SOFTWARE\\Netegrity\\SiteMinder Web Agent\\Microsoft IIS", "newsocketstep");
                    if (newSocketStep == null && newSocketStep.length() == 0) {
                        return -1;
                    }
                    for (int m = 0; m < serverList.size(); ++m) {
                        ServerDef server = (ServerDef)serverList.get(m);
                        server.connectionMax = Integer.parseInt(maxSocketPerPort);
                        server.connectionMin = Integer.parseInt(minSocketPerPort);
                        server.connectionStep = Integer.parseInt(newSocketStep);
                        server.timeout = Integer.parseInt(reqTimeOut);
                        initDef.addServerDef(server);
                    }
                    return 0;
                }
            } else {
                return -1;
            }
        }
        if (foundPath) {
            Map initDefConfig = null;
            try {
                initDefConfig = Util.getConfigAttributes(configPath, passed4xAgentName);
            }
            catch (Exception e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "getConfig", "Error parsing config file, failing: " + e);
                    e.printStackTrace();
                }
                return -1;
            }
            String hostConfigFile = (String)initDefConfig.get(SM_CONF_HOSTCONFIGFILE.getName());
            if (hostConfigFile == null) {
                initDef.setConfigFileName(configPath);
            } else {
                initDef.setConfigFileName(hostConfigFile);
            }
            if (Util.isLogEnabled()) {
                Util.display(4, CLASS_NAME, "getConfig", "Initialized initDef with configFile = " + initDef.getConfigFileName());
            }
            initDef.setHostName((String)initDefConfig.get(SM_CONF_HOST_NAME.getName()));
            initDef.setSharedSecret((String)initDefConfig.get(SM_CONF_SHARED_SECRET.getName()));
            if (initDefConfig.get(SM_CONF_HOSTCONFIG.getName()) != null) {
                if (Util.isLogEnabled()) {
                    Util.display(4, CLASS_NAME, "getConfig", "Bootstrapping to get hostConfigObject = " + initDefConfig.get(SM_CONF_HOSTCONFIG.getName()));
                }
                try {
                    initDefConfig = this.loadHostConfigAttributes(initDefConfig);
                }
                catch (SmAgentApiException e) {
                    if (Util.isLogEnabled()) {
                        Util.display(2, CLASS_NAME, "getConfig", "Exception loading host config attributes, returning FAILURE: " + e);
                        e.printStackTrace();
                    }
                    return -1;
                }
            }
            try {
                Object server;
                boolean clustersExist = false;
                Iterator attributeNames = initDefConfig.keySet().iterator();
                String attributeName = null;
                ArrayList<ServerDef> serverList = new ArrayList<ServerDef>();
                List nonClusterServerList = new ArrayList();
                int threshold = -1;
                boolean failover = false;
                int connectionMax = 2;
                int connectionMin = 2;
                int connectionStep = 2;
                long timeout = 60L;
                String valueString = null;
                while (attributeNames.hasNext()) {
                    attributeName = (String)attributeNames.next();
                    Object value = initDefConfig.get(attributeName);
                    SmConfigAttribute attributeType = SmConfigAttribute.find(attributeName);
                    if (attributeType == null || !attributeType.isMultiValue()) {
                        if (value == null || ((String)value).trim().equals("")) {
                            if (!Util.isLogEnabled()) continue;
                            Util.display(5, CLASS_NAME, "getConfig", "Found null or empty value, skipping attribute = " + attributeName);
                            continue;
                        }
                        valueString = (String)value;
                    }
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "getConfig", "Processing config name = " + attributeName + ", value = " + value);
                    }
                    if (attributeName.startsWith(CLUSTER_PREFIX)) {
                        clustersExist = true;
                        int clusterSequence = Integer.parseInt(attributeName.substring(CLUSTER_PREFIX.length()));
                        String[] servers = valueString.split(CLUSTER_SERVER_SEPARATOR);
                        if (Util.isLogEnabled()) {
                            Util.display(5, CLASS_NAME, "getConfig", "Processing cluster# = " + clusterSequence + ", total servers = " + servers.length);
                        }
                        for (int k = 0; k < servers.length; ++k) {
                            server = servers[k];
                            if (Util.isLogEnabled()) {
                                Util.display(5, CLASS_NAME, "getConfig", "Processing cluster server: " + (String)server);
                            }
                            ServerDef serverDef = this.parseServer((String)server, clusterSequence);
                            serverList.add(serverDef);
                        }
                        if (threshold >= 0) continue;
                        threshold = Integer.parseInt((String)initDefConfig.get(THRESHOLD_ATTRIBUTE));
                        continue;
                    }
                    if (attributeName.equals(SM_CONF_POLICY_SERVER.getName())) {
                        failover = this.isFailoverEnabled(initDefConfig);
                        nonClusterServerList = this.createPolicyServerClusterList((List)value, failover);
                        continue;
                    }
                    if (attributeName.equals(SM_CONF_MAX_SOCKETS_PER_PORT.getName())) {
                        connectionMax = Integer.parseInt(valueString);
                        continue;
                    }
                    if (attributeName.equals(SM_CONF_MIN_SOCKETS_PER_PORT.getName())) {
                        connectionMin = Integer.parseInt(valueString);
                        continue;
                    }
                    if (attributeName.equals(SM_CONF_NEW_SOCKET_STEP.getName())) {
                        connectionStep = Integer.parseInt(valueString);
                        continue;
                    }
                    if (!attributeName.equals(SM_CONF_REQUEST_TIMEOUT.getName())) continue;
                    timeout = Long.parseLong(valueString);
                }
                Util.display(5, CLASS_NAME, "getConfig", "Completed initDef attribute setup");
                if (!clustersExist) {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "getConfig", "No clusters found, total policyserver servers = " + nonClusterServerList.size());
                    }
                    serverList = nonClusterServerList;
                    threshold = failover ? 100 : 0;
                } else if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "getConfig", "Clusters found, total servers = " + serverList.size());
                }
                initDef.setFailOver(failover);
                if (threshold >= 0) {
                    initDef.setFailOverThreshold(threshold);
                }
                Fips140Mode fipsModeObj = Fips140Mode.getFips140ModeObject();
                if (0 == initDef.getCryptoOpMode()) {
                    initDef.setCryptoOpMode(fipsModeObj.getMode());
                }
                for (int m = 0; m < serverList.size(); ++m) {
                    server = (ServerDef)serverList.get(m);
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "getConfig", "Adding to InitDef server=" + ((ServerDef)server).serverIpAddress + ", acct port = " + ((ServerDef)server).accountingPort + ", auth port = " + ((ServerDef)server).authenticationPort + ", az port = " + ((ServerDef)server).authorizationPort);
                    }
                    ((ServerDef)server).connectionMax = connectionMax;
                    ((ServerDef)server).connectionMin = connectionMin;
                    ((ServerDef)server).connectionStep = connectionStep;
                    ((ServerDef)server).timeout = (int)timeout;
                    initDef.addServerDef((ServerDef)server);
                }
            }
            catch (Exception e) {
                if (Util.isLogEnabled()) {
                    Util.display(2, CLASS_NAME, "getConfig", "Failed processing hostconfig attributes: " + e.getMessage());
                    e.printStackTrace();
                }
                return -1;
            }
        }
        return 0;
    }

    public List createPolicyServerClusterList(List policyServers, boolean failover) {
        String methodName = "createPolicyServerClusterList";
        ArrayList<ServerDef> clusteredServers = new ArrayList<ServerDef>();
        int clusterSequence = 1;
        for (int i = 0; i < policyServers.size(); ++i) {
            String policyServer = (String)policyServers.get(i);
            if (Util.isLogEnabled()) {
                Util.display(5, CLASS_NAME, "createPolicyServerClusterList", "Processing policy server = " + policyServer);
            }
            ServerDef server = this.parseServer(policyServer, clusterSequence);
            clusteredServers.add(server);
            if (!failover) continue;
            ++clusterSequence;
        }
        return clusteredServers;
    }

    private boolean isFailoverEnabled(Map initDefConfig) {
        String enableFailOverValue = (String)initDefConfig.get(SM_CONF_ENABLE_FAILOVER.getName());
        return Util.isTrueOrYes(enableFailOverValue);
    }

    private ServerDef parseServer(String serverConfig, int clusterNumber) throws NumberFormatException {
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "parseServer", "Parsing server parts for server = " + serverConfig);
        }
        String[] serverData = serverConfig.split(",");
        ServerDef server = new ServerDef();
        server.serverIpAddress = serverData[0];
        server.accountingPort = serverData.length > 1 && serverData[1] != null && serverData[1].trim().length() != 0 ? Integer.parseInt(serverData[1].trim()) : 44442;
        server.authenticationPort = serverData.length > 2 && serverData[2] != null && serverData[2].trim().length() != 0 ? Integer.parseInt(serverData[2].trim()) : 44442;
        server.authorizationPort = serverData.length > 3 && serverData[3] != null && serverData[3].trim().length() != 0 ? Integer.parseInt(serverData[3].trim()) : 44442;
        server.clusterSeq = clusterNumber;
        return server;
    }

    public int getAgentConfig(String templateName, AttributeList attributeList) {
        return this.m_adapter.getAgentConfig(templateName, attributeList);
    }

    public int createSSOToken(SessionDef sd, AttributeList al, StringBuffer SSOToken) {
        return this.m_adapter.createSSOToken(sd, al, SSOToken);
    }

    public int decodeSSOToken(String SSOToken, TokenDescriptor td, AttributeList al, boolean UpdateToken, StringBuffer UpdatedSSOToken) {
        return this.m_adapter.decodeSSOToken(SSOToken, td, al, UpdateToken, UpdatedSSOToken);
    }

    public int makeCertificateHash(BinaryBuffer cert, BinaryBuffer hash) {
        return this.m_adapter.makeCertificateHash(cert, hash);
    }

    public int tunnel(short server, String clientIpAddr, String transactionId, ResourceContextDef rcd, TunnelServiceRequest tsr, AttributeList responseAttrs) {
        return this.m_adapter.tunnel(server, clientIpAddr, transactionId, rcd, tsr, responseAttrs);
    }

    public int getMaxTunnelBufSize() {
        return this.m_adapter.getMaxTunnelBufSize();
    }

    public int transact(int serverNumber, BinaryBuffer bb) {
        return this.m_adapter.transact(serverNumber, bb);
    }

    public int getMaxTransactBufSize() {
        return this.m_adapter.getMaxTransactBufSize();
    }

    public int getSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList) {
        return this.m_adapter.getSessionVariables(sessionId, rcd, requestAttributeList, responseAttributeList);
    }

    public int getSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList, String transactionId) {
        return this.m_adapter.getSessionVariablesEx(sessionId, rcd, requestAttributeList, responseAttributeList, null);
    }

    public int setSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList) {
        return this.m_adapter.setSessionVariables(sessionId, rcd, requestAttributeList, responseAttributeList);
    }

    public int setSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList, String transactionId) {
        return this.m_adapter.setSessionVariablesEx(sessionId, rcd, requestAttributeList, responseAttributeList, null);
    }

    public int delSessionVariables(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList) {
        return this.m_adapter.delSessionVariables(sessionId, rcd, requestAttributeList, responseAttributeList);
    }

    public int delSessionVariablesEx(String sessionId, ResourceContextDef rcd, AttributeList requestAttributeList, AttributeList responseAttributeList, String transactionId) {
        return this.m_adapter.delSessionVariablesEx(sessionId, rcd, requestAttributeList, responseAttributeList, null);
    }

    protected void finalize() throws Throwable {
        this.unInit();
    }
}

