/*
 * Decompiled with CFR 0.152.
 */
package com.netegrity.util;

import com.netegrity.util.Base64;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.Random;

public class Utils {
    private static long hostID;
    private static Random random;
    private static final String UTF8_CHAR_ENCODING = "UTF-8";

    public static String getStackTrace(Throwable th) {
        StringWriter writer = new StringWriter();
        th.printStackTrace(new PrintWriter(writer));
        writer.flush();
        return writer.toString();
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuffer retString = new StringBuffer(data.length << 1);
        for (int i = 0; i < data.length; ++i) {
            String b = Integer.toHexString(0xFF & data[i]);
            if (b.length() == 1) {
                b = "0" + b;
            }
            retString.append(b);
        }
        return retString.toString();
    }

    public static void Zeroize(byte[] sensitiveData) {
        if (null != sensitiveData) {
            for (int iter = 0; iter < sensitiveData.length; ++iter) {
                sensitiveData[iter] = 0;
            }
        }
    }

    public static void Zeroize(char[] sensitiveData) {
        if (null != sensitiveData) {
            for (int iter = 0; iter < sensitiveData.length; ++iter) {
                sensitiveData[iter] = '\u0000';
            }
        }
    }

    public static String genGUID() {
        StringBuffer sb = new StringBuffer();
        sb.append(Math.round(random.nextDouble() * 9.223372036854776E18));
        sb.append(Math.abs(hostID));
        sb.append(System.currentTimeMillis());
        sb.append(Math.round(random.nextDouble() * 2.147483647E9));
        return "SM" + new BigInteger(sb.toString()).toString(16);
    }

    public static String changeDateFormat(String sRequest) {
        int index = sRequest.indexOf("+00:00");
        while (index != -1) {
            int endIndex = index;
            if (sRequest.charAt(endIndex - 4) == '.') {
                endIndex -= 4;
            }
            sRequest = sRequest.substring(0, endIndex) + "Z" + sRequest.substring(index + "+00:00".length());
            index = sRequest.indexOf("+00:00");
        }
        return sRequest;
    }

    public static String stripAdditionalCharacters(String value) {
        int xmlLastCharIndex;
        int xmlFirstCharIndex = value.indexOf("<");
        if (xmlFirstCharIndex != -1) {
            value = value.substring(xmlFirstCharIndex);
        }
        if ((xmlLastCharIndex = value.lastIndexOf(">")) != -1) {
            value = value.substring(0, xmlLastCharIndex + 1);
        }
        return value;
    }

    public static String normalizeX509SubjectDN(String dn) {
        if (dn == null || dn.equals("")) {
            return "";
        }
        String value = "";
        try {
            char c;
            StringBuffer sb = new StringBuffer();
            StringReader sr = new StringReader(dn);
            int i = 0;
            block5: while ((i = sr.read()) > -1) {
                c = (char)i;
                if (c >= '\u0000' && c <= '\u001f') {
                    sb.append('\\');
                    sb.append(c / 16).append(c % 16);
                    continue;
                }
                switch (c) {
                    case '\"': 
                    case '+': 
                    case ',': 
                    case ';': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        sb.append('\\');
                        sb.append(c);
                        continue block5;
                    }
                }
                sb.append(c);
            }
            value = sb.toString();
            String trimed = value.trim();
            int size = value.length();
            int k = trimed.length();
            k = k != 0 ? (k += value.indexOf(trimed)) : size;
            sb = new StringBuffer();
            if (size > k) {
                char[] chars = value.toCharArray();
                int pos = k;
                for (i = size - 1; i >= 0 && (c = chars[i]) == ' '; --i) {
                    pos = i;
                    if (chars[i - 1] != '\\') continue;
                    if (chars[i - 2] != '\\') break;
                    pos = i - 2;
                    i -= 2;
                }
                for (i = 0; i < size; ++i) {
                    c = chars[i];
                    if (i < pos) {
                        sb.append(c);
                        continue;
                    }
                    if (c == '\\') {
                        if (i + 1 < size && chars[i + 1] == '\\') {
                            if (i + 2 < size && chars[i + 2] == ' ') {
                                sb.append("\\20");
                                i += 2;
                                continue;
                            }
                            sb.append(c).append(chars[i + 1]);
                            continue;
                        }
                        sb.append(c);
                        continue;
                    }
                    if (c == ' ') {
                        sb.append("\\20");
                        continue;
                    }
                    sb.append(c);
                }
                value = sb.toString();
            }
        }
        catch (Throwable t) {
            return dn;
        }
        if (value.startsWith("#")) {
            value = '\\' + value;
        }
        return value;
    }

    public static String deNormalizeX509SubjectDN(String dn) {
        if (dn == null || dn.equals("")) {
            return "";
        }
        String value = "";
        try {
            StringBuffer sb = new StringBuffer();
            StringReader sr = new StringReader(dn);
            int i = 0;
            int cbs = 92;
            int cd2 = 50;
            int cd0 = 48;
            boolean first = true;
            while ((i = sr.read()) > -1) {
                char c = (char)i;
                block1 : switch (c) {
                    case '\\': {
                        i = sr.read();
                        if (i <= -1) break;
                        char c2 = (char)i;
                        block4 : switch (c2) {
                            case '\"': 
                            case '+': 
                            case ',': 
                            case ';': 
                            case '<': 
                            case '>': 
                            case '\\': {
                                sb.append(c2);
                                break;
                            }
                            case '#': {
                                if (first) {
                                    sb.append(c2);
                                    break;
                                }
                                sb.append(c);
                                sb.append(c2);
                                break;
                            }
                            case '0': 
                            case '1': {
                                char c3;
                                int j = sr.read();
                                if (j > -1 && ((c3 = (char)j) >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f')) {
                                    if (c3 >= '0' && c3 <= '9') {
                                        j -= 48;
                                    }
                                    if (c3 >= 'A' && c3 <= 'F') {
                                        j = j - 65 + 10;
                                    }
                                    if (c3 >= 'a' && c3 <= 'f') {
                                        j = j - 97 + 10;
                                    }
                                    j = (i -= 48) * 16 + j;
                                    c3 = (char)(i * 16 + j);
                                    sb.append(c3);
                                    break;
                                }
                                sb.append(c);
                                sb.append(c2);
                                break;
                            }
                            case '2': {
                                i = sr.read();
                                if (i <= -1) break block1;
                                char c3 = (char)i;
                                switch (c3) {
                                    case '0': {
                                        sb.append(" ");
                                        break block4;
                                    }
                                }
                                sb.append(c);
                                sb.append(c2);
                                sb.append(c3);
                                break;
                            }
                            default: {
                                sb.append(c);
                                sb.append(c2);
                                break;
                            }
                        }
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                first = false;
            }
            value = sb.toString();
        }
        catch (Throwable t) {
            return dn;
        }
        return value;
    }

    public static byte[] toBinaryArray(String hexStr) {
        byte[] bArray = new byte[hexStr.length() / 2];
        for (int init = 0; init < hexStr.length() / 2; ++init) {
            byte firstPart = Byte.parseByte(hexStr.substring(2 * init, 2 * init + 1), 16);
            byte secondPart = Byte.parseByte(hexStr.substring(2 * init + 1, 2 * init + 2), 16);
            int finalByte = secondPart | firstPart << 4;
            bArray[init] = (byte)finalByte;
        }
        return bArray;
    }

    public static String getToken(String input, String startToken, String endToken, int offset) {
        String val = "";
        if (input != null && offset < input.length()) {
            int iStartPos = -1;
            int iStartTokenLength = -1;
            if (startToken != null && startToken.length() > 0) {
                iStartPos = input.indexOf(startToken, offset);
                iStartTokenLength = startToken.length();
            } else {
                iStartPos = offset;
                iStartTokenLength = 0;
            }
            int newStartPos = iStartPos + iStartTokenLength;
            if (newStartPos >= offset && newStartPos < input.length()) {
                int iEndPos = -1;
                if (endToken == null || endToken.length() == 0) {
                    iEndPos = input.length();
                } else {
                    iEndPos = input.indexOf(endToken, newStartPos);
                    if (iEndPos < 0) {
                        iEndPos = input.length();
                    }
                }
                if (iEndPos > newStartPos) {
                    val = input.substring(newStartPos, iEndPos);
                }
            }
        }
        return val;
    }

    public static boolean isXSSAttackSuspected(char[] invalidChars, String strToCheck, boolean bB64Decode, boolean bURLDecode) {
        if (strToCheck != null && strToCheck.length() != 0 && invalidChars != null && invalidChars.length > 0) {
            int i;
            String temp = strToCheck;
            try {
                if (bB64Decode) {
                    temp = Base64.decode(temp);
                }
                if (bURLDecode) {
                    for (i = 0; i < 3; ++i) {
                        temp = URLDecoder.decode(temp, UTF8_CHAR_ENCODING);
                    }
                }
            }
            catch (Exception e) {
                return true;
            }
            for (i = 0; i < invalidChars.length; ++i) {
                char invalidChar = invalidChars[i];
                if (temp.indexOf(invalidChar) == -1) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            InetAddress inet = InetAddress.getLocalHost();
            hostID = inet.hashCode();
        }
        catch (Exception se) {
            hostID = 127001L;
        }
        random = new Random(hostID);
    }
}

