/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageException;
import com.ca.siteminder.sdk.agentapi.resources.SmCryptoMessages;
import com.rsa.jsafe.provider.JsafeJCE;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.ResourceBundle;

public class SmPasswordMessage
implements SmAgentApiConstants {
    private static final String MESSAGES_CLASSNAME = SmCryptoMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    private static final int PWDMSG_VERSION = 1;
    private static final int SIZEOF_INT = 4;
    private static int c_FieldsTotal = 0;
    private static int[] c_MessageIDs = null;
    private String m_algorithm = null;
    private int m_version = 1;
    private int m_msgID = 0;
    private int m_length = 0;
    private int m_fieldNum = 0;
    private byte[][] m_fields = null;

    public SmPasswordMessage() throws SmPasswordMessageException {
        this("MD5");
    }

    public SmPasswordMessage(String algorithm) throws SmPasswordMessageException {
        if (c_FieldsTotal == 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_FIELDS_INIT_ERROR"));
        }
        if (c_MessageIDs == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_MSGIDS_INIT_ERROR"));
        }
        this.m_algorithm = algorithm;
        this.m_fields = new byte[c_FieldsTotal][];
        Arrays.fill((Object[])this.m_fields, null);
    }

    public void parse(String message) throws SmPasswordMessageException, SmCryptoProviderException, NoSuchAlgorithmException {
        if (message == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_TOO_SHORT"));
        }
        try {
            byte[] input = SmCryptoProvider.base64decode(message.getBytes("UTF-8"));
            MessageDigest md = MessageDigest.getInstance(this.m_algorithm, (Provider)new JsafeJCE());
            int digestLength = md.getDigestLength();
            if (input.length < digestLength + 16) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_TOO_SHORT"));
            }
            byte[] digest = new byte[digestLength];
            byte[] pwdmsg = new byte[input.length - digestLength];
            System.arraycopy(input, 0, digest, 0, digest.length);
            System.arraycopy(input, digest.length, pwdmsg, 0, pwdmsg.length);
            ByteBuffer pwdBuffer = ByteBuffer.wrap(pwdmsg);
            this.m_version = pwdBuffer.getInt();
            this.m_msgID = pwdBuffer.getInt();
            this.m_length = pwdBuffer.getInt();
            this.m_fieldNum = pwdBuffer.getInt();
            this.validateVersion(this.m_version);
            this.validatePasswordMessageID(this.m_msgID);
            if (this.m_length != input.length) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_LENGTH") + String.valueOf(this.m_length));
            }
            if (this.m_fieldNum < 0) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELDNUM") + String.valueOf(this.m_fieldNum));
            }
            if (!MessageDigest.isEqual(digest, md.digest(pwdmsg))) {
                throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_DIGEST_MISMATCH"));
            }
            for (int m = 0; m < this.m_fieldNum; ++m) {
                int field = pwdBuffer.getInt();
                int size = pwdBuffer.getInt();
                this.validatePasswordField(field);
                if (size <= 0) {
                    throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELD_SIZE") + String.valueOf(size));
                }
                this.m_fields[field] = new byte[size];
                pwdBuffer.get(this.m_fields[field]);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new SmPasswordMessageException(e);
        }
    }

    public String write() throws SmPasswordMessageException, SmCryptoProviderException, NoSuchAlgorithmException {
        this.validateVersion(this.m_version);
        if (this.m_fieldNum < 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELDNUM") + String.valueOf(this.m_fieldNum));
        }
        MessageDigest md = MessageDigest.getInstance(this.m_algorithm, (Provider)new JsafeJCE());
        int digestLength = md.getDigestLength();
        this.m_length = digestLength + 16;
        for (int k = 0; k < c_FieldsTotal; ++k) {
            byte[] value = this.m_fields[k];
            if (value == null) continue;
            this.m_length += value.length + 8;
        }
        ByteBuffer pwdBuffer = ByteBuffer.allocate(this.m_length - digestLength);
        pwdBuffer.putInt(this.m_version);
        pwdBuffer.putInt(this.m_msgID);
        pwdBuffer.putInt(this.m_length);
        pwdBuffer.putInt(this.m_fieldNum);
        for (int field = 0; field < c_FieldsTotal; ++field) {
            byte[] value = this.m_fields[field];
            if (value == null) continue;
            pwdBuffer.putInt(field);
            pwdBuffer.putInt(value.length);
            pwdBuffer.put(value);
        }
        byte[] pwdmsg = pwdBuffer.array();
        byte[] digest = md.digest(pwdmsg);
        byte[] output = new byte[this.m_length];
        System.arraycopy(digest, 0, output, 0, digestLength);
        System.arraycopy(pwdmsg, 0, output, digestLength, this.m_length - digestLength);
        try {
            return new String(SmCryptoProvider.base64encode(output), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SmPasswordMessageException(e);
        }
    }

    public void erase() {
        this.m_version = 1;
        this.m_msgID = 0;
        this.m_length = 0;
        this.m_fieldNum = 0;
        this.m_fields = new byte[c_FieldsTotal][];
        Arrays.fill((Object[])this.m_fields, null);
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) throws SmPasswordMessageException {
        this.validateVersion(version);
        this.m_version = version;
    }

    public int getMessageID() {
        return this.m_msgID;
    }

    public void setMessageID(int msgID) throws SmPasswordMessageException {
        this.validatePasswordMessageID(msgID);
        this.m_msgID = msgID;
    }

    public int getNumberOfFields() {
        return this.m_fieldNum;
    }

    public String getField(int field) throws SmPasswordMessageException {
        this.validatePasswordField(field);
        return new String(this.m_fields[field]);
    }

    public int getFieldInt(int field) throws SmPasswordMessageException {
        this.validatePasswordField(field);
        ByteBuffer buffer = ByteBuffer.wrap(this.m_fields[field]);
        return buffer.getInt();
    }

    public void setField(int field, String value) throws SmPasswordMessageException {
        this.validatePasswordField(field);
        byte[] oldValue = this.m_fields[field];
        if (oldValue == null && value != null) {
            ++this.m_fieldNum;
        } else if (oldValue != null && value == null) {
            --this.m_fieldNum;
        }
        if (value != null) {
            try {
                this.m_fields[field] = value.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SmPasswordMessageException(e);
            }
        } else {
            this.m_fields[field] = null;
        }
    }

    public void setField(int field, int value) throws SmPasswordMessageException {
        this.validatePasswordField(field);
        byte[] oldValue = this.m_fields[field];
        if (oldValue == null) {
            this.m_fields[field] = new byte[4];
            ++this.m_fieldNum;
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.m_fields[field]);
        buffer.putInt(value);
    }

    public void removeField(int field) throws SmPasswordMessageException {
        this.setField(field, null);
    }

    private void validateVersion(int version) throws SmPasswordMessageException {
        if (version > 1 || version <= 0) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_VERSION") + String.valueOf(version));
        }
    }

    private void validatePasswordMessageID(int msgID) throws SmPasswordMessageException {
        if (c_MessageIDs == null) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_MSGID") + String.valueOf(msgID));
        }
        for (int k = 0; k < c_MessageIDs.length; ++k) {
            if (c_MessageIDs[k] != msgID) continue;
            return;
        }
        throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_MSGID") + String.valueOf(msgID));
    }

    private void validatePasswordField(int field) throws SmPasswordMessageException {
        if (field < 0 || field >= c_FieldsTotal) {
            throw new SmPasswordMessageException(c_bundle.getString("M_PWD_MESSAGE_INVALID_FIELD") + String.valueOf(field));
        }
    }

    static {
        try {
            c_FieldsTotal = Class.forName("com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageFields").getFields().length;
        }
        catch (Throwable e) {
            c_FieldsTotal = 0;
            e.printStackTrace();
        }
        try {
            Field[] IDs = Class.forName("com.ca.siteminder.sdk.agentapi.crypto.SmPasswordMessageIDs").getFields();
            c_MessageIDs = new int[IDs.length];
            for (int k = 0; k < IDs.length; ++k) {
                SmPasswordMessage.c_MessageIDs[k] = IDs[k].getInt(null);
            }
        }
        catch (Throwable e) {
            c_MessageIDs = null;
            e.printStackTrace();
        }
    }
}

