/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapi.tools;

import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.dd.IProduct;
import com.ca.siteminder.sdk.adminapi.tools.ClassHelper;
import com.ca.siteminder.sdk.adminapi.tools.Named;
import com.ca.siteminder.sdk.adminapi.tools.VendorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductHelper
extends Named {
    IProduct product;
    VendorHelper vendor;
    private List<ClassHelper> classes;
    private List<ClassHelper> fullClassList;
    private static Map<IProduct, ProductHelper> helpers = new HashMap<IProduct, ProductHelper>();

    ProductHelper(IProduct iProduct, VendorHelper vendorHelper) {
        super(iProduct.getName().toLowerCase(), false);
        boolean bl;
        this.vendor = vendorHelper;
        this.product = iProduct;
        helpers.put(iProduct, this);
        List list = this.product.getClasses();
        this.classes = new ArrayList<ClassHelper>();
        for (String[] stringArray : list) {
            this.classes.add(new ClassHelper((IClass<? extends XPSObject>)stringArray, this));
        }
        this.sortClasses();
        this.fullClassList = this.classes;
        boolean bl2 = bl = vendorHelper.getName().equalsIgnoreCase("ca") && this.getName().equalsIgnoreCase("xps");
        if (bl) {
            String[] stringArray;
            stringArray = new String[]{"Vendor", "Product", "Class", "Attribute", "Bit", "Administrator", "Grant", "Workspace", "SecurityCategory"};
            this.classes = new ArrayList<ClassHelper>();
            Iterator<ClassHelper> iterator = this.fullClassList.iterator();
            block1: while (iterator.hasNext()) {
                ClassHelper classHelper = iterator.next();
                if (ClassHelper.isMetadata(classHelper) || "CA.XPS::MetaAttributes".equals(classHelper.getFqname())) {
                    iterator.remove();
                    continue;
                }
                String string = classHelper.getName();
                for (String string2 : stringArray) {
                    if (string2.equalsIgnoreCase(string)) continue block1;
                }
                this.classes.add(classHelper);
            }
        }
    }

    public List<ClassHelper> getClasses() {
        return this.classes;
    }

    public List<ClassHelper> getFullClassList() {
        return this.fullClassList;
    }

    public VendorHelper getVendor() {
        return this.vendor;
    }

    public int getVersion() {
        return this.product.getDDVersion();
    }

    static ProductHelper get(IProduct iProduct) {
        return helpers.get(iProduct);
    }

    public void setSpecialClass(ClassHelper classHelper) {
        this.fullClassList = Collections.singletonList(classHelper);
        this.classes = this.fullClassList;
    }

    Set<ClassHelper> getReferencedClasses() {
        HashSet<ClassHelper> hashSet = new HashSet<ClassHelper>();
        for (ClassHelper classHelper : this.classes) {
            Set<ClassHelper> set = classHelper.getReferencedClassesFromOtherPackages();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public Set<ProductHelper> getReferencedProducts() {
        Set<ClassHelper> set = this.getReferencedClasses();
        HashSet<ProductHelper> hashSet = new HashSet<ProductHelper>();
        for (ClassHelper classHelper : set) {
            hashSet.add(classHelper.getProduct());
        }
        return hashSet;
    }

    public Map<ProductHelper, List<ClassHelper>> getReferencedClassesByProducts() {
        Set<ClassHelper> set = this.getReferencedClasses();
        Set<ProductHelper> set2 = this.getParentProducts();
        HashMap<ProductHelper, List<ClassHelper>> hashMap = new HashMap<ProductHelper, List<ClassHelper>>();
        for (ClassHelper classHelper : set) {
            ProductHelper productHelper = classHelper.getProduct();
            if (set2.contains(productHelper)) continue;
            ArrayList<ClassHelper> arrayList = (ArrayList<ClassHelper>)hashMap.get(productHelper);
            if (arrayList == null) {
                arrayList = new ArrayList<ClassHelper>();
                hashMap.put(productHelper, arrayList);
            }
            arrayList.add(classHelper);
        }
        return hashMap;
    }

    public Set<ProductHelper> getParentProducts() {
        HashSet<ProductHelper> hashSet = new HashSet<ProductHelper>();
        for (ClassHelper classHelper : this.classes) {
            ProductHelper productHelper;
            ClassHelper classHelper2 = classHelper.getBaseOrExt();
            if (classHelper2 == null || (productHelper = classHelper2.getProduct()) == this) continue;
            hashSet.add(productHelper);
        }
        return hashSet;
    }

    public Set<ProductHelper> getOtherProducts() {
        Set<ProductHelper> set = this.getParentProducts();
        Set<ProductHelper> set2 = this.getReferencedProducts();
        set2.removeAll(set);
        return set2;
    }

    public String getCppClassName(ClassHelper classHelper) {
        if (ClassHelper.isMetadata(classHelper)) {
            return "xps_GenericObject";
        }
        ProductHelper productHelper = classHelper.getProduct();
        String string = classHelper.getName();
        if (this.equals(productHelper)) {
            return string;
        }
        return productHelper.getVendor().getName() + "_" + productHelper.getName() + "_" + string;
    }

    public String getPerlClassName(ClassHelper classHelper) {
        if (ClassHelper.isMetadata(classHelper)) {
            return "xps::Object";
        }
        ProductHelper productHelper = classHelper.getProduct();
        String string = classHelper.getName();
        return productHelper.getVendor().getName() + "::" + productHelper.getName() + "::" + string;
    }

    void sortClasses() {
        ClassHelper classHelper;
        ArrayList<ClassHelper> arrayList = new ArrayList<ClassHelper>();
        HashSet<ClassHelper> hashSet = new HashSet<ClassHelper>();
        for (ClassHelper classHelper2 : this.classes) {
            classHelper = classHelper2.getBaseOrExt();
            if (classHelper == null) {
                arrayList.add(classHelper2);
                continue;
            }
            hashSet.add(classHelper2);
        }
        while (!hashSet.isEmpty()) {
            Iterator<ClassHelper> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ClassHelper classHelper2;
                classHelper2 = iterator.next();
                classHelper = classHelper2.getBaseOrExt();
                if (hashSet.contains(classHelper)) continue;
                arrayList.add(classHelper2);
                iterator.remove();
            }
        }
        this.classes = arrayList;
    }
}

