/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer.main;

import com.ca.siteminder.analyzer.Analyzer;
import com.ca.siteminder.analyzer.Parameters;
import com.ca.siteminder.analyzer.main.MainOptions;
import com.ca.siteminder.analyzer.rec.ObjRec;
import com.ca.siteminder.analyzer.rec.UserDNRec;
import com.ca.siteminder.rpcutil.CommandLineOptions;
import com.ca.smi18n.Smi18n;
import com.ca.smi18n.Xlate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OptionsProcessor {
    private static Xlate xlate = new Xlate("com.ca.siteminder.analyzer.smanalyzerBundle", Smi18n.SmGetAdminLocale());
    protected Analyzer a;

    public OptionsProcessor(MainOptions mainOptions) {
        this.a = mainOptions.local ? new Analyzer(null, null, null) : new Analyzer(mainOptions.conf);
    }

    public static boolean doExit(String string) {
        System.err.println(string);
        System.exit(1);
        return false;
    }

    protected static String extractUserName(String string) {
        int n = string.indexOf("uid=");
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf(44, n += 4);
        String string2 = n2 < 0 ? string.substring(n) : string.substring(n, n2);
        return string2.trim();
    }

    protected String findUserDn(String string, List list) {
        int n = list.size();
        UserDNRec userDNRec = null;
        for (int i = 0; i < n; ++i) {
            userDNRec = (UserDNRec)list.get(i);
            String string2 = OptionsProcessor.extractUserName(userDNRec.getUserName());
            if (!string.equals(string2)) continue;
            return userDNRec.getFullUserDN();
        }
        throw new RuntimeException(xlate.translate("SM-ALY-02025") + string);
    }

    protected List getObjXidList(List list, List list2, String string) {
        ArrayList arrayList = new ArrayList();
        for (String string2 : list) {
            List list3 = this.findObjXidByName(string2, list2, string);
            arrayList.addAll(list3);
        }
        return arrayList;
    }

    protected List findObjXidByName(String string, List list, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        boolean bl = false;
        char c = '*';
        int n2 = string.length();
        String string3 = string;
        if (string.charAt(n2 - 1) == c) {
            bl = true;
            string3 = string.substring(0, n2 - 1);
        }
        for (int i = 0; i < n; ++i) {
            ObjRec objRec = (ObjRec)list.get(i);
            String string4 = objRec.getName();
            boolean bl2 = bl ? string4.startsWith(string3) : string4.equalsIgnoreCase(string3);
            if (!bl2) continue;
            arrayList.add(objRec.getXid());
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException(xlate.translate("SM-ALY-02035") + string2 + ": " + string);
        }
        return arrayList;
    }

    protected List getAgentList(List list) {
        List list2 = this.a.listAgents("*");
        return this.getObjXidList(list, list2, "agent");
    }

    protected List getAppList(List list) {
        Integer n = null;
        List list2 = this.a.listApplications(null, n);
        return this.getObjXidList(list, list2, "application");
    }

    protected List getUserDnList(List list) {
        List list2 = this.a.listUserDn(null, null, null, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = this.findUserDn(string, list2);
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected Parameters prepareReportParameters(MainOptions mainOptions) {
        Parameters parameters = new Parameters(mainOptions.report);
        if (mainOptions.userDnList != null) {
            parameters.addProperties("user_dn", mainOptions.userDnList);
        }
        if (mainOptions.appList != null) {
            parameters.addProperties("application", mainOptions.appList);
        }
        if (mainOptions.agentList != null) {
            parameters.addProperties("agent", mainOptions.agentList);
        }
        if (mainOptions.resource != null) {
            parameters.addProperties("resource", mainOptions.resource);
        }
        if (mainOptions.P != null) {
            for (CommandLineOptions.Entry entry : mainOptions.P) {
                parameters.addProperty(entry.getKey(), entry.getValue());
            }
        }
        if (mainOptions.params != null) {
            Iterator iterator = mainOptions.params.iterator();
            while (iterator.hasNext()) {
                parameters.addProperty((String)iterator.next(), iterator.next());
            }
        }
        parameters.addProperty("domain_appl", mainOptions.scope);
        return parameters;
    }

    protected void processOptions(MainOptions mainOptions) {
        if (mainOptions.user != null) {
            mainOptions.userDnList = this.getUserDnList(mainOptions.user);
        }
        if (mainOptions.appl != null) {
            mainOptions.appList = this.getAppList(mainOptions.appl);
        }
        if (mainOptions.agent != null) {
            mainOptions.agentList = this.getAgentList(mainOptions.agent);
        }
    }
}

