/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.analyzer;

import com.ca.siteminder.analyzer.Analyzer;
import com.ca.siteminder.analyzer.ReportConsumer;
import com.ca.siteminder.analyzer.rec.Record;
import com.ca.siteminder.rpc.rpc.BlockingQueue;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RecordIterator
implements Iterator,
ReportConsumer {
    BlockingQueue queue;
    boolean isDone = false;
    static int defaultBufferSize = 1000;
    private static final Logger logger = Logger.getLogger(RecordIterator.class);
    int count = 0;

    public RecordIterator() {
        this(defaultBufferSize);
    }

    public RecordIterator(int n) {
        this.queue = new BlockingQueue(n);
    }

    synchronized void setDone(String string) {
        logger.info((Object)("report " + string + " ended. Number of records: " + Integer.toString(this.count)));
        this.isDone = true;
        this.notifyAll();
    }

    public synchronized boolean hasNext() {
        while (this.queue.isEmpty() && !this.isDone) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return !this.queue.isEmpty();
    }

    public Object next() {
        try {
            return this.queue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setProgress(int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(Record record) {
        boolean bl = this.queue.isEmpty();
        try {
            this.queue.put((Object)record);
            ++this.count;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        if (bl) {
            RecordIterator recordIterator = this;
            synchronized (recordIterator) {
                this.notify();
            }
        }
    }

    public void print(Analyzer analyzer) {
        while (this.hasNext()) {
            analyzer.reg.print(this.next());
        }
    }
}

