/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.crypto;

import com.ca.siteminder.sdk.agentapi.SmAgentApiCommonConstants;
import com.ca.siteminder.sdk.agentapi.crypto.SmCryptoProviderException;
import com.ca.siteminder.sdk.agentapi.crypto.SmRC2CryptoProvider;
import com.ca.siteminder.sdk.agentapi.crypto.SmSecureRandom;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;

class SmRC2SHA1CryptoProvider
extends SmRC2CryptoProvider
implements SmAgentApiCommonConstants {
    protected MessageDigest m_md = null;

    SmRC2SHA1CryptoProvider(String keyDigestAlg, boolean bAscii) throws SmCryptoProviderException {
        super(keyDigestAlg, bAscii);
        this.m_digestAlg = "SHA";
        this.m_verifyDigest = false;
        try {
            this.m_md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
            this.m_digestLength = this.getBlockSize();
        }
        catch (GeneralSecurityException e) {
            throw new SmCryptoProviderException(e);
        }
    }

    protected byte[] makeDigest(byte[] input, boolean mode) throws SmCryptoProviderException, GeneralSecurityException {
        return this.makeDigest(input, input.length, mode);
    }

    protected byte[] makeDigest(byte[] input, int inLength, boolean mode) throws SmCryptoProviderException, GeneralSecurityException {
        byte[] time = new byte[1];
        byte[] seed = new byte[20];
        long seconds = System.currentTimeMillis() / 1000L;
        time[0] = new Long(seconds).byteValue();
        SmSecureRandom.nextBytes(seed);
        MessageDigest md = null;
        try {
            md = (MessageDigest)this.m_md.clone();
            md.reset();
        }
        catch (CloneNotSupportedException e) {
            md = null;
        }
        if (md == null) {
            md = MessageDigest.getInstance(this.m_digestAlg, (Provider)m_provider);
        }
        md.update(input, 0, inLength);
        try {
            md.update(String.valueOf(seconds).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SmCryptoProviderException(e);
        }
        md.update(seed);
        byte[] digest = md.digest();
        byte[] output = new byte[this.m_digestLength];
        System.arraycopy(digest, 0, output, 0, this.m_digestLength);
        return output;
    }
}

