/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.agentapi.connection;

import com.ca.siteminder.sdk.agentapi.SmAgentApiConstants;
import com.ca.siteminder.sdk.agentapi.SmAgentApiException;
import com.ca.siteminder.sdk.agentapi.SmAgentApiNotInitializedException;
import com.ca.siteminder.sdk.agentapi.Util;
import com.ca.siteminder.sdk.agentapi.config.SmConfigFile;
import com.ca.siteminder.sdk.agentapi.connection.SmAgentApiConnectionException;
import com.ca.siteminder.sdk.agentapi.connection.SmCluster;
import com.ca.siteminder.sdk.agentapi.resources.SmConnectionMessages;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class SmInitDef
implements SmAgentApiConstants {
    public static final int CRYPTO_OP_UNSET = 0;
    public static final int CRYPTO_OP_COMPAT = 1;
    public static final int CRYPTO_OP_MIGRATE_F1402 = 2;
    public static final int CRYPTO_OP_F1402 = 3;
    public static final int CRYPTO_OP_F1402MD5 = 4;
    private static final String CLASS_NAME = "SmInitDef";
    private static final String MESSAGES_CLASSNAME = SmConnectionMessages.getName();
    private static ResourceBundle c_bundle = ResourceBundle.getBundle(MESSAGES_CLASSNAME);
    public static final int DEFAULT_POLICY_SERVER_PORT = 44442;
    public static final int DEFAULT_CONNECTION_MAX = 2;
    public static final int DEFAULT_CONNECTION_MIN = 2;
    public static final int DEFAULT_CONNECTION_STEP = 2;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60;
    private static final String OPENING_SQUARE_BRACKET = "[";
    private static final String CLOSING_SQUARE_BRACKET = "]";
    private static final String IPV6_ADDRESS_SEPERATOR = "]:";
    public static String CLUSTER_SEPARATOR = String.valueOf('\u0003');
    public static String SERVER_SEPARATOR = ",";
    private SmConfigFile m_smConfigFile;
    private String m_unparsedClusterList;
    private List m_clusters = new ArrayList();
    private String m_hostName;
    private String m_sharedSecret;
    private int m_connectionMax;
    private int m_connectionMin;
    private int m_connectionStep;
    private long m_timeout;
    private boolean m_failover;
    private int m_failoverThreshold;
    private List m_attributes;
    private int m_CryptoOpMode = 0;

    public SmInitDef(SmConfigFile smConfigFile, String unparsedClusterList, String hostName, String sharedSecret, int connectionMax, int connectionMin, int connectionStep, long timeout, boolean failover, int failoverThreshold, List attributes) throws SmAgentApiNotInitializedException {
        this(smConfigFile, null, unparsedClusterList, hostName, sharedSecret, connectionMax, connectionMin, connectionStep, timeout, failover, failoverThreshold, attributes);
    }

    public SmInitDef(SmConfigFile smConfigFile, String unparsedClusterList, String hostName, String sharedSecret, String connectionMax, String connectionMin, String connectionStep, String timeout, boolean failover, int failoverThreshold, List attributes) throws SmAgentApiNotInitializedException {
        this(smConfigFile, null, unparsedClusterList, hostName, sharedSecret, SmInitDef.convertParamToInt(connectionMax, "ConnectionMax", 2), SmInitDef.convertParamToInt(connectionMin, "ConnectionMin", 2), SmInitDef.convertParamToInt(connectionStep, "ConnectionStep", 2), SmInitDef.convertParamToLong(timeout, "ConnectionTimeout", 60L), failover, failoverThreshold, attributes);
    }

    public SmInitDef(SmConfigFile smConfigFile, List clusters, String hostName, String sharedSecret, int connectionMax, int connectionMin, int connectionStep, long timeout, boolean failover, int failoverThreshold, List attributes) throws SmAgentApiNotInitializedException {
        this(smConfigFile, clusters, null, hostName, sharedSecret, connectionMax, connectionMin, connectionStep, timeout, failover, failoverThreshold, attributes);
    }

    public SmInitDef(SmConfigFile smConfigFile, List clusters, String hostName, String sharedSecret, String connectionMax, String connectionMin, String connectionStep, String timeout, boolean failover, int failoverThreshold, List attributes) throws SmAgentApiNotInitializedException {
        this(smConfigFile, clusters, null, hostName, sharedSecret, SmInitDef.convertParamToInt(connectionMax, "ConnectionMax", 2), SmInitDef.convertParamToInt(connectionMin, "ConnectionMin", 2), SmInitDef.convertParamToInt(connectionStep, "ConnectionStep", 2), SmInitDef.convertParamToLong(timeout, "ConnectionTimeout", 60L), failover, failoverThreshold, attributes);
    }

    protected SmInitDef(SmConfigFile smConfigFile, List clusters, String unparsedClusterList, String hostName, String sharedSecret, int connectionMax, int connectionMin, int connectionStep, long timeout, boolean failover, int failoverThreshold, List attributes) throws SmAgentApiNotInitializedException {
        String methodName = CLASS_NAME;
        Util.display(5, CLASS_NAME, CLASS_NAME, "Started SmInitDef");
        this.m_smConfigFile = smConfigFile;
        this.m_hostName = hostName;
        this.m_sharedSecret = sharedSecret;
        this.setConnectionMax(connectionMax);
        this.setConnectionMin(connectionMin);
        this.setConnectionStep(connectionStep);
        this.setConnectionTimeout(timeout);
        this.m_failover = failover;
        this.m_failoverThreshold = failoverThreshold;
        this.m_attributes = attributes;
        if (unparsedClusterList == null) {
            this.parseClusters(clusters);
        } else {
            this.parseClusters(unparsedClusterList);
        }
    }

    protected void parseClusters(String unparsedClusterList) throws SmAgentApiNotInitializedException {
        String methodName = "parseClusters";
        if (Util.isLogEnabled()) {
            Util.display(5, CLASS_NAME, "parseClusters", "Started parseClusters w/unparsed name (policyserver): " + unparsedClusterList);
        }
        this.m_unparsedClusterList = unparsedClusterList;
        if (unparsedClusterList == null || unparsedClusterList.trim().length() == 0) {
            Util.display(2, CLASS_NAME, "parseClusters", "Doing no work - recieved no or empty unparsed cluster string");
            return;
        }
        String[] allClusters = unparsedClusterList.split(CLUSTER_SEPARATOR);
        if (allClusters.length == 1) {
            if (!this.m_failover) {
                if (!this.addCluster(allClusters[0])) {
                    throw new SmAgentApiNotInitializedException(c_bundle.getString("M_FAILED_TO_ADD_SERVERS"));
                }
                return;
            }
            boolean bFailedAll = true;
            String[] allServers = allClusters[0].split(SERVER_SEPARATOR);
            for (int i = 0; i < allServers.length; ++i) {
                if (!this.addCluster(allServers[i])) continue;
                bFailedAll = false;
            }
            if (bFailedAll) {
                throw new SmAgentApiNotInitializedException(c_bundle.getString("M_FAILED_TO_ADD_SERVERS"));
            }
            return;
        }
        boolean bFailedAll = true;
        for (int i = 0; i < allClusters.length; ++i) {
            if (!this.addCluster(allClusters[i])) continue;
            bFailedAll = false;
        }
        if (bFailedAll) {
            throw new SmAgentApiNotInitializedException(c_bundle.getString("M_FAILED_TO_ADD_SERVERS"));
        }
    }

    protected void parseClusters(List clusterList) throws SmAgentApiNotInitializedException {
        String methodName = "parseClusters-clusters";
        Util.display(5, CLASS_NAME, "parseClusters-clusters", "Started parseClusters w/cluster list");
        if (clusterList == null || clusterList.size() == 0) {
            Util.display(2, CLASS_NAME, "parseClusters-clusters", "Doing no work - recieved no or empty cluster list");
            return;
        }
        boolean bFailedAll = true;
        for (int k = 0; k < clusterList.size(); ++k) {
            List serverList;
            try {
                serverList = (List)clusterList.get(k);
            }
            catch (ClassCastException e) {
                if (!Util.isLogEnabled()) continue;
                Util.display(2, CLASS_NAME, "parseClusters-clusters", "Server list contains wrong type: " + e);
                continue;
            }
            if (serverList != null) {
                if (Util.isLogEnabled()) {
                    Util.display(5, CLASS_NAME, "parseClusters-clusters", "Adding to cluster server = " + serverList);
                }
                if (!this.addCluster(serverList)) continue;
                bFailedAll = false;
                continue;
            }
            Util.display(3, CLASS_NAME, "parseClusters-clusters", "Attempt to add null serverList to cluster");
        }
        if (bFailedAll) {
            throw new SmAgentApiNotInitializedException(c_bundle.getString("M_FAILED_TO_ADD_SERVERS"));
        }
    }

    protected boolean addCluster(String serverList) {
        String methodName = "addCluster-String serverList";
        Util.display(5, CLASS_NAME, "addCluster-String serverList", "Started addCluster- String serverList");
        SmCluster cluster = new SmCluster();
        String[] allServers = serverList.split(SERVER_SEPARATOR);
        try {
            cluster.init(allServers.length, this.m_failoverThreshold);
            cluster.setState(0, 3);
        }
        catch (SmAgentApiConnectionException e) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "addCluster-String serverList", "Failed to initialize cluster for config = " + serverList + ": " + e);
            }
            cluster.setState(0, 5);
            return false;
        }
        int addedServers = 0;
        for (int i = 0; i < allServers.length; ++i) {
            InetSocketAddress serverAddress = this.getServerAddress(allServers[i]);
            try {
                cluster.addServer(serverAddress, this, 1536);
                ++addedServers;
                continue;
            }
            catch (SmAgentApiConnectionException e) {
                if (!Util.isLogEnabled()) continue;
                Util.display(3, CLASS_NAME, "addCluster-String serverList", "Failed to add cluster server (ignoring) " + allServers[i] + ": " + e);
            }
        }
        if (addedServers > 0) {
            this.m_clusters.add(cluster);
            return true;
        }
        return false;
    }

    protected boolean addCluster(List serverList) {
        String methodName = "addCluster-List serverList";
        if (serverList == null) {
            Util.display(3, CLASS_NAME, "addCluster-List serverList", "Ignoring attempt to add a null cluster");
            return false;
        }
        SmCluster cluster = new SmCluster();
        try {
            cluster.init(serverList.size(), this.m_failoverThreshold);
            cluster.setState(0, 3);
        }
        catch (SmAgentApiConnectionException e) {
            Util.display(2, CLASS_NAME, "addCluster-List serverList", "Failed to init cluster");
            cluster.setState(0, 5);
            return false;
        }
        int addedServers = 0;
        for (int k = 0; k < serverList.size(); ++k) {
            String serverAddr;
            try {
                serverAddr = (String)serverList.get(k);
            }
            catch (ClassCastException e) {
                if (!Util.isLogEnabled()) continue;
                Util.display(2, CLASS_NAME, "addCluster-List serverList", "Server list contains wrong type: " + e);
                continue;
            }
            if (serverAddr != null) {
                InetSocketAddress serverAddress = this.getServerAddress(serverAddr);
                try {
                    if (Util.isLogEnabled()) {
                        Util.display(5, CLASS_NAME, "addCluster-List serverList", "Adding to cluster server = " + serverAddr);
                    }
                    cluster.addServer(serverAddress, this, 1536);
                    ++addedServers;
                }
                catch (SmAgentApiConnectionException e) {
                    if (!Util.isLogEnabled()) continue;
                    Util.display(2, CLASS_NAME, "addCluster-List serverList", "Failed to add server to cluster - IP = " + serverAddress.getHostName());
                }
                continue;
            }
            Util.display(3, CLASS_NAME, "addCluster-List serverList", "Attempt to add null server to cluster");
        }
        if (addedServers > 0) {
            this.m_clusters.add(cluster);
            return true;
        }
        return false;
    }

    public SmConfigFile getSmConfigFile() {
        return this.m_smConfigFile;
    }

    public void setSmConfigFile(SmConfigFile smConfigFile) {
        this.m_smConfigFile = smConfigFile;
    }

    public List getClusters() {
        return this.m_clusters;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public String getSharedSecret() {
        return this.m_sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.m_sharedSecret = sharedSecret;
    }

    public int getMaxConnections() {
        return this.m_connectionMax;
    }

    public int getDefaultConnections() {
        return this.m_connectionMin;
    }

    public int getConnectionIncrement() {
        return this.m_connectionStep;
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public boolean getFailover() {
        return this.m_failover;
    }

    public int getFailoverThreshold() {
        return this.m_failoverThreshold;
    }

    public List getAttributes() {
        return this.m_attributes;
    }

    protected void setConnectionMax(int connectionMax) throws SmAgentApiNotInitializedException {
        if (connectionMax <= 0) {
            throw new SmAgentApiNotInitializedException("Connection max = " + connectionMax + " must be > 0");
        }
        this.m_connectionMax = connectionMax;
    }

    protected void setConnectionMin(int connectionMin) throws SmAgentApiNotInitializedException {
        this.m_connectionMin = connectionMin;
    }

    protected void setConnectionStep(int connectionStep) throws SmAgentApiNotInitializedException {
        this.m_connectionStep = connectionStep;
    }

    protected void setConnectionTimeout(long connectionTimeout) throws SmAgentApiNotInitializedException {
        if (connectionTimeout <= 0L) {
            throw new SmAgentApiNotInitializedException("Connection timeout = " + connectionTimeout + " must be > 0");
        }
        this.m_timeout = connectionTimeout;
    }

    private static long convertParamToLong(String param, String name, long defaultValue) throws SmAgentApiNotInitializedException {
        if (param == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(param);
        }
        catch (NumberFormatException e) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "convertParamToLong", "Invalid number format for param = " + name);
            }
            throw new SmAgentApiNotInitializedException(e);
        }
    }

    private static int convertParamToInt(String param, String name, int defaultValue) throws SmAgentApiNotInitializedException {
        if (param == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "convertParamToInt", "Invalid number format for param = " + name);
            }
            throw new SmAgentApiNotInitializedException(e);
        }
    }

    private InetSocketAddress getServerAddress(String hostNPort) {
        try {
            return Util.parseHostNPort(hostNPort);
        }
        catch (SmAgentApiException ex) {
            if (Util.isLogEnabled()) {
                Util.display(2, CLASS_NAME, "getServerAddress", "Exception caught during parsing");
            }
            return null;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("hostName=" + this.m_hostName);
        buffer.append(", unparsedClusterList=" + this.m_unparsedClusterList);
        buffer.append(", connectionMax=" + this.m_connectionMax);
        buffer.append(", connectionMin=" + this.m_connectionMin);
        buffer.append(", connectionStep=" + this.m_connectionStep);
        buffer.append(", timeout=" + this.m_timeout);
        buffer.append(", failover=" + this.m_failover);
        buffer.append(", failoverThreshold=" + this.m_failoverThreshold);
        buffer.append(", sharedSecret=" + this.m_sharedSecret);
        return buffer.toString();
    }

    public void setCryptoOpMode(int cryptoOpMode) {
        this.m_CryptoOpMode = cryptoOpMode;
    }

    public int getCryptoOpMode() {
        return this.m_CryptoOpMode;
    }
}

