/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.ConnectionHelper;
import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.Session;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Admin;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Workspace;
import com.ca.siteminder.sdk.adminapi.ca.xps.WorkspaceEntry;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.EnumSet;
import netegrity.siteminder.javaagent.AgentAPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuritySetup
extends SetupConnection {
    public static Administrator admin2;
    public static Session session2;
    public static PolicyData policyData2;
    public static Admin legacy;
    static String adminNamePrefix;
    public static String adminName;
    public static String adminPwd;
    public static String domainAdmin;
    public static String applAdmin;
    public static String agentAdmin;
    static String currentSecurityCategory;

    public SecuritySetup(String string, Class<? extends TestBase> clazz) {
        super(clazz);
        currentSecurityCategory = string;
    }

    public SecuritySetup(Class<? extends TestBase> clazz) {
        super(clazz);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.doSecuritySetup();
    }

    void doSecuritySetup() throws Exception {
        adminName = adminNamePrefix + random;
        this.createXPSAdmin();
        this.createSession();
    }

    @Override
    public void tearDown() {
        if (session2 != null) {
            session2.disconnect();
        }
        if (legacy != null) {
            policyData.deleteObject((XPSObject)legacy);
        }
        if (admin2 != null) {
            policyData.deleteObject((XPSObject)admin2);
        }
        super.tearDown();
    }

    public static void connect2() {
        session2.connect();
        policyData2 = session2.getPolicyData();
    }

    public static String getLegacyNamespace() {
        Administrator administrator = SetupConnection.security.getAdmin();
        String string = administrator.getUserPath();
        int n = string.indexOf("://");
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(47, n += 3);
        if (n2 > 0) {
            n = n2 + 1;
        }
        return string.substring(0, n);
    }

    void createXPSAdmin() {
        admin2 = security.newAdministrator();
        admin2.setName(adminName);
        admin2.setUserPath(SecuritySetup.getLegacyNamespace() + adminName);
        admin2.clearFlags();
        EnumSet<Administrator.MethodsAllowed> enumSet = EnumSet.of(Administrator.MethodsAllowed.RemoteAPI, Administrator.MethodsAllowed.LocalAPI);
        admin2.setMethodsAllowed(enumSet);
        security.createAdministrator(admin2);
        legacy = (Admin)policyData.newObject((IClass)Admin.ddclass);
        legacy.setName(adminName);
        legacy.setPassword(adminPwd);
        EnumSet<Admin.Rights> enumSet2 = EnumSet.noneOf(Admin.Rights.class);
        legacy.setRights(enumSet2);
        policyData.createObject((XPSObject)legacy);
    }

    void createSession() throws Exception {
        AgentAPI agentAPI;
        ConnectionHelper connectionHelper = new ConnectionHelper();
        connectionHelper.agentapi = agentAPI = session.getConnection();
        String string = connectionHelper.PMAPI_login(adminName, adminPwd);
        session2 = new Session();
        session2.setConnection(agentAPI);
        session2.setSessionTicket(string);
    }

    public static void createObject2(XPSObject xPSObject) {
        STIUtil.createObject(session2, policyData2, xPSObject);
        toDelete.add(xPSObject);
    }

    public static void updateObject2(XPSObject xPSObject) {
        STIUtil.updateObject(session2, policyData2, xPSObject);
    }

    public static void deleteObject2(XPSObject xPSObject) {
        toDelete.remove(xPSObject);
        STIUtil.deleteObject(session2, policyData2, xPSObject);
    }

    public static Workspace makeWorkspace(String string) {
        Workspace workspace = (Workspace)policyData.newObject((IClass)Workspace.ddclass);
        if (string != null) {
            workspace.setName(string);
        }
        return workspace;
    }

    public static WorkspaceEntry makeWorkspaceEntry(Workspace workspace) {
        WorkspaceEntry workspaceEntry = (WorkspaceEntry)policyData.newObject((IClass)WorkspaceEntry.ddclass);
        workspaceEntry.setParent(workspace);
        return workspaceEntry;
    }

    public static SecurityCategory makeSecurityCategory(String string) {
        if (string == null) {
            string = domainAdmin;
        }
        SecurityCategory securityCategory = (SecurityCategory)policyData.fetchObject(string);
        return securityCategory;
    }

    public static SecurityCategory makeDomainAdmin() {
        return SecuritySetup.makeSecurityCategory(domainAdmin);
    }

    public static Grant makeGrant(Administrator administrator, SecurityCategory securityCategory) {
        if (securityCategory == null) {
            securityCategory = SecuritySetup.makeSecurityCategory(null);
        }
        Grant grant = security.newGrant();
        grant.setParent(administrator);
        int n = 0x200000;
        grant.setRightsMask(Integer.valueOf(n));
        grant.setSecurityCategory(securityCategory);
        return grant;
    }

    static {
        adminNamePrefix = "smtestadmin";
        adminPwd = "firewall";
        domainAdmin = "CA.XPS::SecurityCategory@!Domain Administration";
        applAdmin = "CA.XPS::SecurityCategory@!Application Administration";
        agentAdmin = "CA.XPS::SecurityCategory@!Agent Administration";
        currentSecurityCategory = applAdmin;
    }
}

