/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.security;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.Security;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.ca.xps.ClassCategory;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.dd.DDClass;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityBase
extends TestBase {
    static SecurityCategory seccat;
    static Grant grant;
    List<XPSObject> scope;
    Set<ClassCategory.RightsMask> possibleClassRights;
    Map<String, ClassCategory> classCategories;
    static String securityMsg;

    SecurityBase() {
    }

    void doSetup(String string) {
        Administrator administrator = SecuritySetup.admin2;
        if (grant != null) {
            this.deleteObject((XPSObject)grant);
        }
        grant = SecuritySetup.makeGrant(administrator, seccat);
        grant.setRightsMask(Integer.valueOf(Security.convertRights((String)string)));
        if (this.scope != null && !this.scope.isEmpty()) {
            grant.setScope(this.scope);
        }
        this.createObject((XPSObject)grant);
        this.updateObject((XPSObject)administrator);
        this.setPossibleRights(string);
        this.setClassCategories();
    }

    void setClassCategories() {
        this.classCategories = new HashMap<String, ClassCategory>();
        SecurityCategory securityCategory = grant.getSecurityCategory();
        List list = securityCategory.getChildren((IClass)ClassCategory.ddclass);
        for (ClassCategory classCategory : list) {
            String string = classCategory.get_class().getFQName();
            this.classCategories.put(string, classCategory);
        }
    }

    <T extends XPSObject> ClassCategory findClassCategory(DDClass<T> dDClass) {
        ClassCategory classCategory = this.classCategories.get(dDClass.getFQName());
        if (classCategory == null && dDClass.getBaseClass() != null) {
            classCategory = this.classCategories.get(dDClass.getBaseClass().getFQName());
        }
        return classCategory;
    }

    void setPossibleRights(String string) {
        this.possibleClassRights = new HashSet<ClassCategory.RightsMask>();
        int n = string.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'C': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Create);
                    continue block11;
                }
                case 'U': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Update);
                    continue block11;
                }
                case 'D': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Delete);
                    continue block11;
                }
                case 'T': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Traverse);
                    continue block11;
                }
                case 'S': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Search);
                    continue block11;
                }
                case 'R': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Read);
                    continue block11;
                }
                case 'V': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Traverse);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Search);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Read);
                    continue block11;
                }
                case 'M': {
                    this.possibleClassRights.add(ClassCategory.RightsMask.Create);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Update);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Delete);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Traverse);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Search);
                    this.possibleClassRights.add(ClassCategory.RightsMask.Read);
                    continue block11;
                }
                case 'P': {
                    continue block11;
                }
            }
        }
    }

    <T extends XPSObject> boolean hasRight(DDClass<T> dDClass, XPSObject xPSObject, ClassCategory.RightsMask rightsMask) {
        if (!this.possibleClassRights.contains(rightsMask)) {
            return false;
        }
        if (xPSObject != null && !this.inScope(xPSObject)) {
            return false;
        }
        ClassCategory classCategory = this.findClassCategory(dDClass);
        if (classCategory == null) {
            return false;
        }
        Set set = classCategory.getRightsMask();
        return set.contains(rightsMask);
    }

    boolean classInScope(GenericObject genericObject) {
        SecurityCategory securityCategory = grant.getSecurityCategory();
        Class clazz = securityCategory.getScopingClass();
        if (clazz == null) {
            return false;
        }
        while (genericObject != null) {
            if (genericObject.isInstanceOf((IClass)clazz)) {
                return true;
            }
            genericObject = genericObject.getParent();
        }
        return false;
    }

    boolean scopeContains(XPSObject xPSObject) {
        String string = xPSObject.getXid();
        if (string == null) {
            return false;
        }
        for (XPSObject xPSObject2 : this.scope) {
            String string2 = xPSObject2.getXid();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    boolean inScope(XPSObject xPSObject) {
        if (!grant.hasScope()) {
            return true;
        }
        GenericObject genericObject = xPSObject.castToGenericObject();
        if (!this.classInScope(genericObject)) {
            return true;
        }
        while (genericObject != null) {
            if (this.scopeContains((XPSObject)genericObject)) {
                return true;
            }
            genericObject = genericObject.getParent();
        }
        return false;
    }

    <T extends XPSObject> boolean canCreate(DDClass<T> dDClass, XPSObject xPSObject) {
        return this.hasRight(dDClass, xPSObject, ClassCategory.RightsMask.Create);
    }

    <T extends XPSObject> boolean canDelete(DDClass<T> dDClass, XPSObject xPSObject) {
        return this.hasRight(dDClass, xPSObject, ClassCategory.RightsMask.Delete);
    }

    <T extends XPSObject> boolean canUpdate(DDClass<T> dDClass, XPSObject xPSObject) {
        return this.hasRight(dDClass, xPSObject, ClassCategory.RightsMask.Update);
    }

    <T extends XPSObject> boolean canSearch(DDClass<T> dDClass, XPSObject xPSObject) {
        return this.hasRight(dDClass, xPSObject, ClassCategory.RightsMask.Search);
    }

    <T extends XPSObject> void tryCreate(DDClass<T> dDClass, XPSObject xPSObject) {
        if (this.canCreate(dDClass, xPSObject)) {
            this.createObject2(xPSObject);
        } else {
            SecurityBase.failCreate2(xPSObject);
        }
    }

    <T extends XPSObject> void tryUpdate(DDClass<T> dDClass, XPSObject xPSObject) {
        if (this.canUpdate(dDClass, xPSObject)) {
            this.updateObject2(xPSObject);
        } else {
            SecurityBase.failUpdate2(xPSObject);
        }
    }

    <T extends XPSObject> void tryDelete(DDClass<T> dDClass, XPSObject xPSObject) {
        if (this.canDelete(dDClass, xPSObject)) {
            this.deleteObject2(xPSObject);
        } else {
            SecurityBase.failDelete2(xPSObject);
        }
    }

    <T extends XPSObject> void trySearchByName(DDClass<T> dDClass, String string) {
        T t = STIUtil.fetchByName(SetupConnection.policyData, dDClass, string);
        if (this.canSearch(dDClass, (XPSObject)t)) {
            T t2 = STIUtil.fetchByName(SecuritySetup.policyData2, dDClass, string);
            SecurityBase.assertNotNull((String)("No object fetched with the name " + string), t2);
        } else {
            SecurityBase.failSearchByName2(dDClass, string);
        }
    }

    protected static void failCreate2(XPSObject xPSObject) {
        STIUtil.failCreate(SecuritySetup.policyData2, xPSObject, securityMsg);
    }

    protected static void failUpdate2(XPSObject xPSObject) {
        STIUtil.failUpdate(SecuritySetup.policyData2, xPSObject, securityMsg);
    }

    protected static void failDelete2(XPSObject xPSObject) {
        STIUtil.failDelete(SecuritySetup.policyData2, xPSObject, securityMsg);
    }

    protected static <T extends XPSObject> void failSearchByName2(DDClass<T> dDClass, String string) {
        STIUtil.failSearchByNameOrNoObjectReturned(SecuritySetup.policyData2, dDClass, string, securityMsg);
    }

    protected void createObject2(XPSObject xPSObject) {
        SecuritySetup.createObject2(xPSObject);
    }

    protected void updateObject2(XPSObject xPSObject) {
        SecuritySetup.updateObject2(xPSObject);
    }

    protected void deleteObject2(XPSObject xPSObject) {
        SecuritySetup.deleteObject2(xPSObject);
    }

    public void addScope(XPSObject xPSObject) {
        if (this.scope == null) {
            this.scope = new ArrayList<XPSObject>();
        }
        this.scope.add(xPSObject);
    }

    public void clearScope() {
        if (this.scope != null) {
            this.scope.clear();
        }
    }

    static {
        securityMsg = "sufficient rights";
    }
}

