/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.rolesexp;

import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.RoleExpBase;
import com.ca.siteminder.sdk.adminapitest.RoleExpSetup;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RoleExpTestQS
extends RoleExpBase {
    static String queryString = "imageType=jpeg&color=red&Rel";

    @TestBase.STI(value=1)
    public void QS_noargs() throws XPSException {
        this.evalStringExpr("QS()", queryString);
    }

    @TestBase.STI(value=2)
    public void QS_nokey() throws XPSException {
        this.evalStringExpr("QS('Rel', '')", "Rel");
    }

    @TestBase.STI(value=3)
    public void QS_imageType() throws XPSException {
        this.evalStringExpr("QS('imageType=jpeg', 'imageType')", "jpeg");
    }

    @TestBase.STI(value=4)
    public void QS_color() throws XPSException {
        this.evalStringExpr("QS(,'color')", "red");
    }

    @TestBase.STI(value=5)
    public void QS_empty() throws XPSException {
        this.evalStringExpr("QS(,'')", "Rel");
    }

    @TestBase.STI(value=6)
    public void QS_Case_sensitive() throws XPSException {
        this.evalStringExpr("QS('imageType=jpeg&R&color=red&Rel', 'color', FALSE)", "red");
        this.evalStringExpr("QS('imageType=jpeg&R&color=red&Rel', 'Color', FALSE)", "red", false);
    }

    @TestBase.STI(value=7)
    public void QS_Case_insensitive() throws XPSException {
        this.evalStringExpr("QS('imageType=jpeg&R&color=red&Rel', 'color', TRUE)", "red");
        this.evalStringExpr("QS('imageType=jpeg&R&color=red&Rel', 'Color', TRUE)", "red");
    }

    @TestBase.STI(value=8)
    public void QS_arg_list() throws XPSException {
        String string = "'a=a1&R&a=a2&R&a=a3'";
        this.evalStringExpr("QS(" + string + ", 'a')", "a1^a2^a3");
        this.evalStringExpr("QS(" + string + ", '')", "R^R");
    }

    @TestBase.STI(value=9)
    public void QS_reset() throws XPSException {
        boolean bl = expSetup.isProtected(null);
        RoleExpTestQS.assertTrue((String)"isProtected", (boolean)bl);
        this.evalStringExpr("QS()", "");
        expSetup.isProtected("foo");
        this.evalStringExpr("QS()", "foo");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RoleExpTestQS.suite());
    }

    public static Test suite() {
        return new RoleExpSetup(RoleExpTestQS.class, RoleExpSetup.AuthSchemeType.Basic, RoleExpSetup.SetupType.Basic, queryString);
    }
}

