/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.Config;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class XPSConfigTest
extends TestBase {
    @TestBase.STI(value=1)
    public void testXPSStringParam() throws Exception {
        this.testXPSConfigParameters(SetupConnection.configXPS, "AutosweepSchedule", "Mon@11:1", false);
    }

    @TestBase.STI(value=2)
    public void testXPSNumericParam() throws Exception {
        this.testXPSConfigParameters(SetupConnection.configXPS, "AuditRolloverSize", "52", false);
    }

    @TestBase.STI(value=3)
    public void testXPSBooleanParam() throws Exception {
        this.testXPSConfigParameters(SetupConnection.configXPS, "AuditEnabled", "false", false);
    }

    @TestBase.STI(value=4)
    public void testSMNotDymamicBooleanParam() throws Exception {
        this.testXPSConfigParameters(SetupConnection.configSM, "ConfidenceLevelSupportEnabled", "true", false);
    }

    @TestBase.STI(value=5)
    public void testEPMBooleanParam() throws Exception {
        this.testXPSConfigParameters(SetupConnection.configEPM, "LogRoleResult", "false", false);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)XPSConfigTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(XPSConfigTest.class);
    }

    protected void testXPSConfigParameters(Config config, String string, String string2, Boolean bl) throws Exception {
        String string3 = config.getDefaultValue(string);
        String string4 = config.getValue(string);
        String string5 = config.getPendingValue(string);
        XPSConfigTest.assertNotNull((String)"Default value must not be null", (Object)string3);
        XPSConfigTest.assertNotNull((String)"Current value must not be null", (Object)string4);
        XPSConfigTest.assertNotNull((String)"Pending value must not be null", (Object)string5);
        config.setValue(string, string2);
        String string6 = config.getValue(string);
        String string7 = config.getPendingValue(string);
        if (!bl.booleanValue()) {
            XPSConfigTest.assertEquals((String)"The pending value must be equal to the new one", (String)string7, (String)string2);
            XPSConfigTest.assertEquals((String)"Current value should not be changed", (String)string4, (String)string6);
        } else {
            XPSConfigTest.assertEquals((String)"Current value must be equal to the new one", (String)string6, (String)string2);
        }
        config.resetValue(string);
        String string8 = config.getValue(string);
        String string9 = config.getPendingValue(string);
        if (!bl.booleanValue()) {
            XPSConfigTest.assertEquals((String)"The pending value must be equal to default value", (String)string9, (String)string3);
            XPSConfigTest.assertEquals((String)"Current value should not be changed", (String)string8, (String)string6);
        } else {
            XPSConfigTest.assertEquals((String)"Current value must be equal to default value", (String)string8, (String)string3);
        }
    }
}

