/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.PolicyData;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.epm.Application;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class SearchTest
extends TestBase {
    static Domain domain;
    static PolicyData policyData;
    static long random;
    static Application app;

    public void setUpSuite() {
        super.setUpSuite();
        random = SetupConnection.random;
        domain = SetupConnection.builder.doDomainSetUp("TestSearchUserDir" + random, "TestSearchAgent1" + random, null, "TestSearchDomain" + random, "TestSearchRealm" + random, "TestSearchRule" + random, "TestSearchResponse" + random, "TestSearchPolicy" + random);
        policyData = SetupConnection.policyData;
    }

    @TestBase.STI(value=1)
    public void testSimpleSearch() {
        List list = policyData.search((IClass)Domain.ddclass);
        SearchTest.assertTrue((String)"domain", (boolean)list.contains(domain));
    }

    @TestBase.STI(value=2)
    public void testChildren() {
        List list = domain.getChildren((IClass)Realm.ddclass);
        SearchTest.assertSize("realms", list, 1);
        Realm realm = (Realm)list.get(0);
        SearchTest.assertEquals((Object)realm.getParent(), (Object)domain);
    }

    @TestBase.STI(value=3)
    public void testRelation() {
        UserDirectory userDirectory = (UserDirectory)domain.getUserDirectories().get(0);
        List list = userDirectory.getRelated("Ca.SM::Domain.UserDirectoriesLink");
        SearchTest.assertSize("d", list, 1);
        SearchTest.assertEquals((Object)domain, list.get(0));
    }

    @TestBase.STI(value=4)
    public void testExtension() {
        app = (Application)policyData.newObject((IClass)Application.ddclass);
        String string = "TestSearchApp" + random;
        app.setName(string);
        this.createObject((XPSObject)app);
        List list = policyData.search((IClass)Application.ddclass);
        SearchTest.assertTrue((boolean)list.contains(app));
        for (Application application : list) {
            SearchTest.assertTrue((boolean)application.hasIsAnApplication());
        }
    }

    @TestBase.STI(value=5)
    public void testExcludeExtension() {
        List list = policyData.search((IClass)Domain.ddclass);
        SearchTest.assertFalse((String)"domains", (boolean)list.contains(app));
    }

    @TestBase.STI(value=6)
    public void testIncludeExtension() {
        List list = policyData.search((IClass)Domain.ddclass, null, false);
        SearchTest.assertTrue((String)"domains", (boolean)list.contains(app));
    }

    public void testDoubleRelation() {
        Realm realm = (Realm)domain.getChildren((IClass)Realm.ddclass).get(0);
        Agent agent = realm.getAgent();
        AgentType agentType = agent.getAgentType();
        List list = agentType.getRelated("CA.SM::Realm.AgentLink?CA.SM::Agent.AgentTypeLink");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SearchTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(SearchTest.class);
    }
}

