/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.functional;

import com.ca.siteminder.sdk.adminapi.GenericObject;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.xps.Attribute;
import com.ca.siteminder.sdk.adminapi.ca.xps.Class;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GenericObjectTest
extends TestBase {
    Class a4xclass;
    Class aclass;
    Class pclass;
    GenericObject agent4x;
    GenericObject agent;

    public void setUp() {
        this.a4xclass = SetupConnection.dictionary.fetchClass("CA.SM::Agent4x");
        this.aclass = SetupConnection.dictionary.fetchClass("CA.SM::Agent");
        this.pclass = SetupConnection.dictionary.fetchClass("CA.SM::Policy");
        this.agent4x = (GenericObject)SetupConnection.policyData.newObject((IClass)this.a4xclass);
        this.agent = (GenericObject)SetupConnection.policyData.newObject((IClass)this.aclass);
    }

    @TestBase.STI(value=1)
    public void cast() {
        GenericObjectTest.assertEquals((String)"Agent4x Class must match with Generic Object class", this.agent4x.getClass(), GenericObject.class);
        GenericObjectTest.assertTrue((String)"Agent4x class must be an instance of CA.SM::Agent Class", (boolean)this.agent4x.isInstanceOf((IClass)this.aclass));
        GenericObjectTest.assertTrue((String)"Agent4x class must be an instance of CA::SM.Agent4x Class", (boolean)this.agent4x.isInstanceOf((IClass)this.a4xclass));
        GenericObjectTest.assertFalse((String)"Agent4x class should not be an instance of CA.SM::Policy Class", (boolean)this.agent4x.isInstanceOf((IClass)this.pclass));
        GenericObjectTest.assertFalse((String)"Agent4x class should not be an instance of Policy Class", (boolean)this.agent4x.isInstanceOf((IClass)Policy.ddclass));
        GenericObjectTest.assertFalse((String)"Agent class shoud not be an instance of CA.SM::Agent4x Class", (boolean)this.agent.isInstanceOf((IClass)this.a4xclass));
    }

    @TestBase.STI(value=2)
    public void stringField() {
        Attribute attribute = this.a4xclass.getAttribute("Secret");
        GenericObjectTest.assertNotNull((String)"Failed to fetch Secret attribute", (Object)attribute);
        String string = "firewall";
        this.agent4x.set((IAttribute)attribute, (Object)"firewall");
        String string2 = (String)this.agent4x.get((IAttribute)attribute);
        GenericObjectTest.assertEquals((String)"secret attribute is not set", (String)string, (String)string2);
        try {
            this.agent4x.set((IAttribute)attribute, (Object)12);
            GenericObjectTest.fail((String)"secret attribute must fail to set to 12");
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
        try {
            Integer n = (Integer)this.agent4x.get((IAttribute)attribute);
            GenericObjectTest.fail((String)"secret attribute fetch must fail");
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            this.agent4x.set((IAttribute)attribute, new ArrayList());
            GenericObjectTest.fail((String)"secret Attribute must fail to set to an array list");
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
        try {
            this.agent4x.set((IAttribute)attribute, null);
            GenericObjectTest.fail((String)"secret attribute must fail to set to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.agent4x.set((IAttribute)attribute, (Object)"");
    }

    @TestBase.STI(value=3)
    public void wrongField() {
        Attribute attribute = this.pclass.getAttribute("Name");
        GenericObjectTest.assertNotNull((String)"Failed to fetch \"Name\" attribute", (Object)attribute);
        try {
            this.agent4x.set((IAttribute)attribute, (Object)"A");
            GenericObjectTest.fail((String)"\"Name\" attribute value must not get updated successfully");
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
        try {
            this.agent4x.get((IAttribute)attribute);
            GenericObjectTest.fail((String)"Fetching attribute, \"Name\", value should fail");
        }
        catch (XPSException xPSException) {
            // empty catch block
        }
    }

    @TestBase.STI(value=5)
    public void create() {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        String string = "agent" + SetupConnection.random;
        this.agent.set((IAttribute)Agent.AGENTTYPE, (Object)agentType);
        this.agent.set((IAttribute)Agent.NAME, (Object)string);
        this.createObject((XPSObject)this.agent);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GenericObjectTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GenericObjectTest.class);
    }
}

