/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.User;
import com.ca.siteminder.sdk.adminapi.ValidatePasswordResponse;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.PasswordPolicy;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import junit.framework.Test;
import junit.textui.TestRunner;

public class UserTestPasswordPolicy
extends TestBaseDMS {
    static User dsbUser;
    static User pwdUser;
    static User grpUser;
    static PasswordPolicy pwdPolicy;

    public void setUpSuite() {
        super.setUpSuite();
        dsbUser = dir.fetchUser(fullUserDsbDN);
        grpUser = dir.fetchUser(fullUserGrpDN);
        pwdUser = dir.fetchUser(fullUserPwdDN);
        String string = userDirectory.getName();
        pwdPolicy = ObjectBuilder.makePasswordPolicy(string, userDirectory);
        pwdPolicy.setPWMinAlpha(Integer.valueOf(0));
        pwdPolicy.setPWMinLowerAlpha(Integer.valueOf(0));
        pwdPolicy.setPWMinUpperAlpha(Integer.valueOf(0));
        pwdPolicy.setPWMinNonAlpha(Integer.valueOf(0));
        pwdPolicy.setPWMinAlphaNum(Integer.valueOf(0));
        pwdPolicy.setPWMinPunctuation(Integer.valueOf(0));
        pwdPolicy.setPWMinLength(Integer.valueOf(2));
        pwdPolicy.setPWMaxLength(Integer.valueOf(6));
        this.createObject((XPSObject)pwdPolicy);
    }

    @TestBase.STI(value=1)
    public void testValidatePasswordLength() throws XPSException {
        String string = "12345";
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertTrue((String)"valid", (boolean)validatePasswordResponse.isValid());
        string = "1";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertFalse((String)"invalid", (boolean)validatePasswordResponse.isValid());
        UserTestPasswordPolicy.assertEquals((int)1001, (int)validatePasswordResponse.getMsgId());
        UserTestPasswordPolicy.assertEquals((String)"Short", (String)validatePasswordResponse.getMsg());
        string = "12345678";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertFalse((String)"invalid", (boolean)validatePasswordResponse.isValid());
        UserTestPasswordPolicy.assertEquals((int)1002, (int)validatePasswordResponse.getMsgId());
    }

    @TestBase.STI(value=2)
    public void testValidatePasswordPunctuation() throws XPSException {
        pwdPolicy.setPWMinPunctuation(Integer.valueOf(1));
        this.updateObject((XPSObject)pwdPolicy);
        String string = "12!34";
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertTrue((String)"valid", (boolean)validatePasswordResponse.isValid());
        string = "!12!34";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertTrue((String)"valid", (boolean)validatePasswordResponse.isValid());
        string = "12345";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertFalse((String)"invalid", (boolean)validatePasswordResponse.isValid());
        UserTestPasswordPolicy.assertEquals((int)1011, (int)validatePasswordResponse.getMsgId());
    }

    @TestBase.STI(value=3)
    public void testValidatePasswordMinAlpha() throws XPSException {
        pwdPolicy.setPWMinPunctuation(Integer.valueOf(0));
        pwdPolicy.setPWMinAlpha(Integer.valueOf(1));
        this.updateObject((XPSObject)pwdPolicy);
        String string = "12A34";
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertTrue((String)"valid", (boolean)validatePasswordResponse.isValid());
        string = "a12b34";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertTrue((String)"valid", (boolean)validatePasswordResponse.isValid());
        string = "12345";
        validatePasswordResponse = pwdUser.validatePassword(string, false, false);
        UserTestPasswordPolicy.assertFalse((String)"invalid", (boolean)validatePasswordResponse.isValid());
        UserTestPasswordPolicy.assertEquals((int)1008, (int)validatePasswordResponse.getMsgId());
    }

    @TestBase.STI(value=4)
    public void testChangePasswordInvalid() throws XPSException {
        try {
            pwdUser.changePassword("", "1", true);
            UserTestPasswordPolicy.fail((String)"Should not be here");
        }
        catch (ServerException serverException) {
            UserTestPasswordPolicy.assertEquals((String)"user.changePassword", (String)serverException.getTag());
            Object[] objectArray = serverException.getArgs();
            UserTestPasswordPolicy.assertNotNull((Object)objectArray);
            UserTestPasswordPolicy.assertEquals((int)2, (int)objectArray.length);
            UserTestPasswordPolicy.assertEquals((Object)1001, (Object)objectArray[0]);
            UserTestPasswordPolicy.assertEquals((Object)"Short", (Object)objectArray[1]);
        }
    }

    @TestBase.STI(value=5)
    public void testChangePasswordWrongOld() throws XPSException {
        try {
            pwdUser.changePassword("xyz1", "abcd56", false);
            UserTestPasswordPolicy.fail((String)"Should not be here");
        }
        catch (ServerException serverException) {
            UserTestPasswordPolicy.assertEquals((String)"user.changePassword", (String)serverException.getTag());
            Object[] objectArray = serverException.getArgs();
            UserTestPasswordPolicy.assertNotNull((Object)objectArray);
            UserTestPasswordPolicy.assertEquals((int)2, (int)objectArray.length);
            UserTestPasswordPolicy.assertEquals((Object)1003, (Object)objectArray[0]);
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserTestPasswordPolicy.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(UserTestPasswordPolicy.class);
    }
}

