/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.User;
import com.ca.siteminder.sdk.adminapi.ValidatePasswordResponse;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;

public class UserTest
extends TestBaseDMS {
    static User dsbUser;
    static User pwdUser;
    static User grpUser;

    public void setUpSuite() {
        super.setUpSuite();
        dsbUser = dir.fetchUser(fullUserDsbDN);
        grpUser = dir.fetchUser(fullUserGrpDN);
        pwdUser = dir.fetchUser(fullUserPwdDN);
    }

    @TestBase.STI(value=1)
    public void testDisableUser() throws XPSException {
        dsbUser.enable(1);
    }

    @TestBase.STI(value=2)
    public void testGetDisabled() throws XPSException {
        int n = dsbUser.getDisabled();
        int n2 = n & 1;
        UserTest.assertEquals((String)"User \"DMSTestUserDisabled\" must be disabled", (int)1, (int)n2);
    }

    @TestBase.STI(value=3)
    public void testEnableUser() throws XPSException {
        dsbUser.enable(0);
    }

    @TestBase.STI(value=4)
    public void testGetGroups() throws XPSException {
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (!string.equalsIgnoreCase("ODBC:")) {
            UserTest.skip("Raised RTC defect 138702 to see why this is consistently failing for " + string);
        }
        List list = grpUser.getGroups(true);
        UserTest.assertSize("list", list, 2);
    }

    @TestBase.STI(value=5)
    public void testIsInGroup() throws XPSException {
        String string = SetupConnection.properties.get("USERDIR_NAMESPACE");
        if (!string.equalsIgnoreCase("ODBC:")) {
            UserTest.skip("Raised RTC defect 138702 to see why this is consistently failing for " + string);
        }
        List list = grpUser.getGroups(true);
        UserTest.assertNotEmpty("list", list);
        boolean bl = grpUser.isInGroup(((ResultEntry)list.get(0)).getDN());
        UserTest.assertTrue((boolean)bl);
    }

    @TestBase.STI(value=6)
    public void testIsInGroup_InvalidGroup() throws XPSException {
        boolean bl = grpUser.isInGroup("jnjrehfuhhnn");
        UserTest.assertFalse((boolean)bl);
    }

    @TestBase.STI(value=7)
    public void testSetPasswordMustChange() throws XPSException {
        pwdUser.setPasswordMustChange();
        pwdUser.enable(0);
    }

    @TestBase.STI(value=8)
    public void testValidatePassword() throws XPSException {
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validatePassword("TestPassword1234&Abc", false, false);
        UserTest.assertTrue((String)"Password must be valid", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=9)
    public void testGetAttributes() throws XPSException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(testAttr);
        Map map = grpUser.getAttributes(arrayList);
        UserTest.assertNotEmpty("user.getAttributes()", map);
        List list = (List)map.get(testAttr);
        UserTest.assertNotEmpty("password attribute", list);
    }

    @TestBase.STI(value=10)
    public void testSetAttributes() throws XPSException {
        List list;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(testAttr);
        Map map = grpUser.getAttributes(arrayList);
        UserTest.assertNotEmpty("user.getAttributes()", map);
        List list2 = list = (List)map.get(testAttr);
        list2.set(0, "2");
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put(testAttr, list2);
        int n = grpUser.setAttributes(hashMap);
        UserTest.assertTrue((String)"testUser.setAttributes() must return  positive value", (n > 0 ? 1 : 0) != 0);
        HashMap<String, List> hashMap2 = new HashMap<String, List>();
        hashMap2.put(testAttr, list);
        grpUser.setAttributes(hashMap2);
    }

    @TestBase.STI(value=11)
    public void testValidateNewPassword() throws XPSException {
        ValidatePasswordResponse validatePasswordResponse = pwdUser.validateNewPassword("OrigPassword11", "NewPassword11", false, false);
        UserTest.assertTrue((String)"validate password failed", (boolean)validatePasswordResponse.isValid());
    }

    @TestBase.STI(value=12)
    public void testChangePassword_NotRequireOldPassword() throws XPSException {
        pwdUser.changePassword("", "NewPassword11", true);
        pwdUser.changePassword("", "OrigPassword11", true);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(UserTest.class);
    }
}

