/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.dms;

import com.ca.siteminder.sdk.adminapi.ResultEntry;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Expression;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapi.filter.UserLookupExpr;
import com.ca.siteminder.sdk.adminapitest.SetupConnectionDMS;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.TestBaseDMS;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.textui.TestRunner;

public class DirectoryTest
extends TestBaseDMS {
    @TestBase.STI(value=1)
    public void testFetchUserRoot() throws XPSException {
        dir.fetchUser(fullUserSrcDN);
    }

    @TestBase.STI(value=2)
    public void testFetchUserInvalidDn() throws XPSException {
        String string = "ckkkkkddkk";
        try {
            dir.fetchUser(string);
            DirectoryTest.fail((String)"fetchUser succeeded for invalid DN");
        }
        catch (ServerException serverException) {
            DirectoryTest.assertEquals((String)"Exception tag must match directory.fetchUser", (String)serverException.getTag(), (String)"directory.fetchUser");
        }
    }

    @TestBase.STI(value=3)
    public void testFetchUserEmptyDn() throws XPSException {
        try {
            dir.fetchUser("");
            DirectoryTest.fail((String)"fetchUser succeeded for empty DN");
        }
        catch (ServerException serverException) {
            DirectoryTest.assertEquals((String)"Exception tag must match directory.fetchUser", (String)serverException.getTag(), (String)"directory.fetchUser");
        }
    }

    @TestBase.STI(value=4)
    public void testCheckConnectionStore() throws XPSException {
        int n = dir.checkConnection();
        DirectoryTest.assertEquals((String)"Directory is not reachable", (int)0, (int)n);
    }

    @TestBase.STI(value=5)
    public void testSearchUsingClauseExpr_All_Users() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.ENDSWITH, (Object)"");
        List list = dir.search(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotEmpty("directory.search returned null", list);
    }

    @TestBase.STI(value=6)
    public void testSearchUsingClauseExpr_Specific_User() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        List list = dir.search1(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotEmpty("search", list);
        DirectoryTest.assertContains(((ResultEntry)list.get(0)).getDN(), userSearchName);
    }

    @TestBase.STI(value=7)
    public void testSearchUsingClauseExpr_Contains_User() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.BEGINSWITH, (Object)"user", false);
        List list = dir.search(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotEmpty("directory search", list);
    }

    @TestBase.STI(value=8)
    public void testSearchUsingUserLookupExpr() throws XPSException {
        UserLookupExpr userLookupExpr = new UserLookupExpr(UserLookupExpr.Operator.EQUAL, (Object)userSearchName);
        List list = dir.search1(userLookupExpr, null, searchOptions);
        DirectoryTest.assertNotEmpty("directory.search returned null", list);
        DirectoryTest.assertTrue((String)("directory search result list must contain user \"" + userSearchName + "\""), (boolean)((ResultEntry)list.get(0)).getDN().contains(userSearchName));
    }

    @TestBase.STI(value=9)
    public void testSearchUsingUserLookupExpr2() throws XPSException {
        UserLookupExpr userLookupExpr = new UserLookupExpr(UserLookupExpr.Operator.EQUAL, (Object)userSearchName, false);
        List list = dir.search(userLookupExpr, null, searchOptions);
        DirectoryTest.assertNotEmpty("directory.search returned null", list);
        DirectoryTest.assertContains(((ResultEntry)list.get(0)).getDN(), userSearchName);
    }

    @TestBase.STI(value=10)
    public void testSearchUsingUserLookupExpr3() throws XPSException {
        UserLookupExpr userLookupExpr = new UserLookupExpr(UserLookupExpr.Operator.EQUAL, (Object)userSearchName, true);
        List list = dir.search(userLookupExpr, null, searchOptions);
        DirectoryTest.assertNotEmpty("directory.search returned null", list);
        DirectoryTest.assertContains(((ResultEntry)list.get(0)).getDN(), userSearchName);
    }

    @TestBase.STI(value=11)
    public void testSearchUsingBooleanExpr() throws XPSException {
        Clause clause = new Clause(uid, Clause.Operator.CONTAINS, (Object)"");
        Clause clause2 = new Clause(uid, Clause.Operator.CONTAINS, (Object)userSearchName);
        Filter filter = new Filter((Expression)clause);
        Filter filter2 = new Filter((Expression)clause2);
        filter.ANDNOT(filter2);
        List list = dir.search(null, filter.getExpression(), searchOptions);
        DirectoryTest.assertNotEmpty("directory.search returned null", list);
        for (ResultEntry resultEntry : list) {
            DirectoryTest.assertFalse((boolean)resultEntry.getDN().equals(fullUserSrcDN));
        }
    }

    @TestBase.STI(value=12)
    public void testSearchReturnAttributes() {
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        String string = "Disabled";
        List<String> list = Collections.singletonList(string);
        searchOptions.setAttrNames(list);
        List list2 = dir.search1(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotEmpty("result", list2);
        ResultEntry resultEntry = (ResultEntry)list2.get(0);
        DirectoryTest.assertContains(resultEntry.getDN(), userSearchName);
        Map map = resultEntry.getAttributes();
        DirectoryTest.assertNotNull((Object)map);
        List list3 = (List)map.get(string);
        DirectoryTest.assertNotEmpty("vals ", list3);
    }

    @TestBase.STI(value=13)
    public void testSearchReturnAttributesGetValues() {
        searchOptions.setGetValuesFlag(true);
        Clause clause = new Clause(uid, Clause.Operator.EQUAL, (Object)userSearchName);
        String string = "Disabled";
        List<String> list = Collections.singletonList(string);
        searchOptions.setAttrNames(list);
        List list2 = dir.search1(null, (Expression)clause, searchOptions);
        DirectoryTest.assertNotEmpty("result", list2);
        ResultEntry resultEntry = (ResultEntry)list2.get(0);
        DirectoryTest.assertContains(resultEntry.getDN(), userSearchName);
        Map map = resultEntry.getAttributes();
        DirectoryTest.assertNotNull((Object)map);
        List list3 = (List)map.get(string);
        DirectoryTest.assertNotEmpty("vals ", list3);
    }

    @TestBase.STI(value=14)
    public void testGetCapabilities() throws XPSException {
        long l = dir.getCapabilities();
        DirectoryTest.assertTrue((l > 0L ? 1 : 0) != 0);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DirectoryTest.suite());
    }

    public static Test suite() {
        return new SetupConnectionDMS(DirectoryTest.class);
    }
}

