/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.xps;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapi.ca.xps.Grant;
import com.ca.siteminder.sdk.adminapi.ca.xps.SecurityCategory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GrantTest
extends TestBase {
    private static Grant m_grant;
    private static Administrator admin;
    private static Domain domain;

    @TestBase.STI(value=1)
    public void testCreateGrantWithAdmin() throws XPSException {
        m_grant = this.doGrantSetup(true, true);
    }

    @TestBase.STI(value=2)
    public void testSearchGrant() throws XPSException {
        List list = admin.getChildren((IClass)Grant.ddclass);
        GrantTest.assertFalse((String)"Administrator should have grants", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateGrant() throws XPSException {
        int n = 4096;
        m_grant.setRightsMask(Integer.valueOf(n));
        this.updateObject((XPSObject)m_grant);
    }

    @TestBase.STI(value=4)
    public void testGrantDeployment() throws XPSException {
        try {
            InternalTesting.testDeployment(SetupConnection.session, (XPSObject)m_grant);
            GrantTest.fail((String)"exported grant");
        }
        catch (ServerException serverException) {
            GrantTest.assertContains(serverException.getMsg(), "not exportable");
        }
    }

    @TestBase.STI(value=5)
    public void testDeleteGrant() throws XPSException {
        this.deleteObject((XPSObject)m_grant);
        this.clearGrantSetup();
    }

    @TestBase.STI(value=6)
    public void testGrantWithoutParent() throws XPSException {
        this.doGrantSetup(false, true);
        this.clearGrantSetup();
    }

    @TestBase.STI(value=7)
    public void testGrantWithoutSecurityCategory() throws XPSException {
        this.doGrantSetup(true, false);
        this.clearGrantSetup();
    }

    private Grant doGrantSetup(boolean bl, boolean bl2) throws XPSException {
        Grant grant = null;
        SetupConnection.session.begin();
        try {
            domain = (Domain)SetupConnection.policyData.newObject((IClass)Domain.ddclass);
            domain.setName("GrantDomain" + SetupConnection.random);
            SetupConnection.policyData.createObject((XPSObject)domain);
            admin = ObjectBuilder.makeAdministrator(SecuritySetup.getLegacyNamespace() + "GrantAdmin" + SetupConnection.random);
            SetupConnection.security.createAdministrator(admin);
            grant = (Grant)SetupConnection.policyData.newObject((IClass)Grant.ddclass);
            ArrayList<Domain> arrayList = new ArrayList<Domain>();
            arrayList.add(domain);
            String string = "CA.XPS::SecurityCategory@!Application Administration";
            SecurityCategory securityCategory = (SecurityCategory)SetupConnection.policyData.fetchObject(string);
            if (bl) {
                grant.setParent(admin);
            }
            if (bl2) {
                grant.setSecurityCategory(securityCategory);
            }
            int n = 0x200000;
            grant.setRightsMask(Integer.valueOf(n));
            grant.setScope(arrayList);
            if (!bl) {
                this.failCreate((XPSObject)grant, "parent");
            } else if (!bl2) {
                this.failCreate((XPSObject)grant, "SecurityCategory");
            } else {
                SetupConnection.policyData.createObject((XPSObject)grant);
                this.checkObject((XPSObject)grant);
            }
            SetupConnection.session.commit(true);
        }
        catch (RuntimeException runtimeException) {
            SetupConnection.session.cancel();
            throw runtimeException;
        }
        return grant;
    }

    private void clearGrantSetup() throws XPSException {
        SetupConnection.session.begin();
        SetupConnection.policyData.deleteObject((XPSObject)domain);
        SetupConnection.security.deleteAdministrator(admin);
        SetupConnection.session.commit();
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GrantTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GrantTest.class);
    }
}

