/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.xps;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.ServerException;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.xps.Administrator;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.security.SecuritySetup;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AdministratorTest
extends TestBase {
    static Administrator admin;

    @TestBase.STI(value=1)
    public void testCreateAdministrator() throws XPSException {
        String string = SecuritySetup.getLegacyNamespace() + "Administrator" + SetupConnection.random;
        admin = ObjectBuilder.makeAdministrator(string);
        this.createObject((XPSObject)admin);
    }

    @TestBase.STI(value=2)
    public void testSearchAdministrator() throws XPSException {
        SetupConnection.fetchByName(Administrator.ddclass, admin.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAdministrator() throws XPSException {
        admin.setName(SecuritySetup.getLegacyNamespace() + "UpdateAdmin" + SetupConnection.random);
        admin.setDescription("update" + admin.getName());
        this.updateObject((XPSObject)admin);
    }

    @TestBase.STI(value=4)
    public void testAdministratorDeployment() throws XPSException {
        try {
            InternalTesting.testDeployment(SetupConnection.session, (XPSObject)admin);
            AdministratorTest.fail((String)"exported Administrator");
        }
        catch (ServerException serverException) {
            AdministratorTest.assertContains(serverException.getMsg(), "not exportable");
        }
    }

    @TestBase.STI(value=5)
    public void testDeleteAdministrator() throws XPSException {
        this.deleteObject((XPSObject)admin);
        admin = null;
    }

    @TestBase.STI(value=6)
    public void testAdministratorWithoutName() throws XPSException {
        admin = ObjectBuilder.makeAdministrator(null);
        this.failCreate((XPSObject)admin, "Name");
    }

    @TestBase.STI(value=7)
    public void testAdministratorWithoutUserPath() throws XPSException {
        String string = SecuritySetup.getLegacyNamespace() + "Administrator2" + SetupConnection.random;
        admin = ObjectBuilder.makeAdministrator(string);
        admin.clearUserPath();
        this.failCreate((XPSObject)admin, "UserPath");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AdministratorTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AdministratorTest.class);
    }
}

