/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Policy;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserPolicy;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class UserPolicyTest
extends TestBase {
    static UserDirectory userDir;
    static UserPolicy userPolicy;
    static Policy policy;

    public void setUpSuite() {
        String string = "TestUserPolicy" + SetupConnection.random;
        String string2 = "TestUserPolicyUserDir" + SetupConnection.random;
        SetupConnection.builder.doDomainSetUp(string2, "TestUserPolicyAgent1" + SetupConnection.random, null, "TestUserPolicyDomain" + SetupConnection.random, "TestUserPolicyRealm" + SetupConnection.random, "TestUserPolicyRule" + SetupConnection.random, "TestUserPolicyResponse" + SetupConnection.random, string);
        userDir = (UserDirectory)SetupConnection.fetchByName(UserDirectory.ddclass, string2);
        policy = (Policy)SetupConnection.fetchByName(Policy.ddclass, string);
    }

    @TestBase.STI(value=1)
    public void testCreateUserPolicy() throws XPSException {
        userPolicy = UserPolicyTest.makeUserPolicy(policy, userDir);
        this.createObject((XPSObject)userPolicy);
    }

    @TestBase.STI(value=2)
    public void testSearchUserPolicy() {
        Filter filter = new Filter((IAttribute)UserPolicy.FILTERCLASS, Clause.Operator.EQUAL, (Object)"userPolicy");
        Filter filter2 = new Filter((IAttribute)UserPolicy.FILTERPATH, Clause.Operator.EQUAL, (Object)"/test/");
        filter.AND(filter2);
        List list = SetupConnection.policyData.search((IClass)UserPolicy.ddclass, filter);
        UserPolicyTest.assertNotEmpty("AuthAzMaps", list);
    }

    @TestBase.STI(value=3)
    public void testUpdateUserPolicy() throws XPSException {
        userPolicy.setFilterClass("updateUserPolicy");
        this.updateObject((XPSObject)userPolicy);
    }

    @TestBase.STI(value=4)
    public void testUserPolicyDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)userPolicy);
    }

    @TestBase.STI(value=5)
    public void testDeleteUserPolicy() throws XPSException {
        this.deleteObject((XPSObject)userPolicy);
        userPolicy = null;
    }

    @TestBase.STI(value=6)
    public void testPolicyLinkWithoutParent() throws XPSException {
        userPolicy = UserPolicyTest.makeUserPolicy(null, userDir);
        this.failCreate((XPSObject)userPolicy, "parent");
    }

    @TestBase.STI(value=7)
    public void testPolicyLinkWithoutClass() throws XPSException {
        userPolicy = UserPolicyTest.makeUserPolicy(policy, userDir);
        userPolicy.clearFilterClass();
        this.failCreate((XPSObject)userPolicy, "FilterClass");
    }

    @TestBase.STI(value=8)
    public void testPolicyLinkWithoutPath() throws XPSException {
        userPolicy = UserPolicyTest.makeUserPolicy(policy, userDir);
        userPolicy.clearFilterPath();
        this.failCreate((XPSObject)userPolicy, "FilterPath");
    }

    @TestBase.STI(value=9)
    public void CascadeDelete() throws XPSException {
        userPolicy = UserPolicyTest.makeUserPolicy(policy, userDir);
        this.createObject((XPSObject)userPolicy);
        String string = userPolicy.getXid();
        InternalTesting.removeFromCache(SetupConnection.session, (XPSObject)userPolicy);
        this.deleteObject((XPSObject)userDir);
        userPolicy = (UserPolicy)SetupConnection.policyData.fetchObject(string, true);
        UserPolicyTest.assertNull((String)"userPolicy", (Object)userPolicy);
    }

    public static UserPolicy makeUserPolicy(Policy policy, UserDirectory userDirectory) throws XPSException {
        UserPolicy userPolicy = (UserPolicy)SetupConnection.policyData.newObject((IClass)UserPolicy.ddclass);
        if (policy != null) {
            userPolicy.setParent(policy);
        }
        userPolicy.setFilterClass("userPolicy");
        userPolicy.setFilterPath("/test/");
        userPolicy.setPolicyResolution(UserPolicy.PolicyResolution.All);
        if (userDirectory != null) {
            userPolicy.setUserDirectory(userDir);
        }
        return userPolicy;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)UserPolicyTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(UserPolicyTest.class);
    }
}

