/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Response;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class ResponseTest
extends TestBase {
    static Domain domain;
    static AgentType agentType;
    static Response response;

    @TestBase.STI(value=1)
    public void testCreateResponse() throws XPSException {
        SetupConnection.builder.doDomainSetUp("TestResponseUserDir" + SetupConnection.random, "TestResponseAgent1" + SetupConnection.random, null, "TestResponseDomain" + SetupConnection.random, null, null, null, null);
        domain = (Domain)SetupConnection.fetchByName(Domain.ddclass, "TestResponseDomain" + SetupConnection.random);
        agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        String string = "Response" + SetupConnection.random;
        response = ObjectBuilder.makeResponse(string, domain, agentType);
        this.createObject((XPSObject)response);
        List list = domain.getChildren((IClass)Response.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Response)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        ResponseTest.assertTrue((String)"Response, created, must found in the existing Responses", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchResponse() {
        SetupConnection.fetchByName(Response.ddclass, response.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateResponse() throws XPSException {
        response.setName("update" + response.getName());
        response.setDesc("update" + response.getDesc());
        this.updateObject((XPSObject)response);
    }

    @TestBase.STI(value=4)
    public void testResponseDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)response);
    }

    @TestBase.STI(value=5)
    public void testDeleteResponse() throws XPSException {
        this.deleteObject((XPSObject)response);
        response = null;
    }

    @TestBase.STI(value=6)
    public void testResponseWithoutName() throws XPSException {
        response = ObjectBuilder.makeResponse(null, domain, agentType);
        this.failCreate((XPSObject)response, "Name");
    }

    @TestBase.STI(value=7)
    public void testResponseWithoutDomain() throws XPSException {
        String string = "Response" + SetupConnection.random;
        response = ObjectBuilder.makeResponse(string, null, agentType);
        this.failCreate((XPSObject)response, "parent");
    }

    @TestBase.STI(value=8)
    public void testResponseWithoutAgentType() throws XPSException {
        String string = "Response" + SetupConnection.random;
        response = ObjectBuilder.makeResponse(string, domain, null);
        this.failCreate((XPSObject)response, "AgentTypeLink");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ResponseTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(ResponseTest.class);
    }
}

