/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AuthScheme;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.Realm;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.STIUtil;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class RealmTest
extends TestBase {
    static Agent agent;
    static AuthScheme authScheme;
    static Domain domain;
    static Realm realm;
    static Realm parentRealm;
    static Realm siblingRealm;

    @TestBase.STI(value=1)
    public void testCreateRealm() throws XPSException {
        domain = SetupConnection.builder.doDomainSetUp("TestRealmUserDir" + SetupConnection.random, "TestRealmAgent1" + SetupConnection.random, "TestRealmAgent2" + SetupConnection.random, "TestRealmDomain" + SetupConnection.random, "TestRealm" + SetupConnection.random, null, null, null);
        agent = (Agent)SetupConnection.fetchByName(Agent.ddclass, "testrealmagent2" + SetupConnection.random);
        authScheme = (AuthScheme)SetupConnection.fetchByName(AuthScheme.ddclass, "Basic");
        String string = "Realm" + SetupConnection.random;
        realm = ObjectBuilder.makeRealm(string, agent, authScheme, domain);
        this.createObject((XPSObject)realm);
        List list = domain.getChildren((IClass)Realm.ddclass);
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Realm)list.get(i)).getName().equals(string)) continue;
            bl = true;
        }
        RealmTest.assertTrue((String)"Realm, created, must found in existing realms", (boolean)bl);
    }

    @TestBase.STI(value=2)
    public void testSearchRealm() {
        SetupConnection.fetchByName(Realm.ddclass, realm.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateRealm() throws XPSException {
        realm.setName("update" + realm.getName());
        realm.setDesc("update" + realm.getDesc());
        this.updateObject((XPSObject)realm);
    }

    @TestBase.STI(value=4)
    public void testRealmDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)realm);
    }

    @TestBase.STI(value=5)
    public void testDeleteRealm() throws XPSException {
        this.deleteObject((XPSObject)realm);
        realm = null;
    }

    @TestBase.STI(value=6)
    public void testRealmWithoutName() throws XPSException {
        realm = ObjectBuilder.makeRealm(null, agent, authScheme, domain);
        this.failCreate((XPSObject)realm, "Name");
    }

    @TestBase.STI(value=7)
    public void testRealmWithoutDomain() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = ObjectBuilder.makeRealm(string, agent, authScheme, null);
        this.failCreate((XPSObject)realm, "parent");
    }

    @TestBase.STI(value=8)
    public void testRealmWithoutAgent() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = ObjectBuilder.makeRealm(string, null, authScheme, domain);
        this.failCreate((XPSObject)realm, "AgentLink");
    }

    @TestBase.STI(value=9)
    public void testRealmWithoutAuthScheme() throws XPSException {
        String string = "Realm" + SetupConnection.random;
        realm = ObjectBuilder.makeRealm(string, agent, null, domain);
        this.failCreate((XPSObject)realm, "AuthSchemeLink");
    }

    @TestBase.STI(value=10)
    public void testCreateNestedRealm() throws XPSException {
        List list = domain.getChildren((IClass)Realm.ddclass);
        RealmTest.assertFalse((String)"No realms exists under \"TestRealmDomain\"", (list.size() == 0 ? 1 : 0) != 0);
        parentRealm = (Realm)list.get(0);
        String string = "NestedRealm " + SetupConnection.random;
        realm = ObjectBuilder.makeRealm(string, parentRealm.getAgent(), parentRealm.getAuthScheme(), domain);
        realm.clearResourceFilter();
        realm.setParentRealm(parentRealm);
        realm.setResourceFilter("Test10/");
        this.createObject((XPSObject)realm);
    }

    @TestBase.STI(value=11)
    public void uniqueResourceNestedRealmPositive() throws XPSException {
        realm.setResourceFilter(parentRealm.getResourceFilter());
        this.updateObject((XPSObject)realm);
    }

    @TestBase.STI(value=12)
    public void uniqueResourceNestedRealmNegative() throws XPSException {
        siblingRealm = realm.duplicate();
        siblingRealm.setName(realm.getName() + "_sibling");
        STIUtil.failCreate(SetupConnection.policyData, (XPSObject)siblingRealm, "Duplicate");
    }

    @TestBase.STI(value=13)
    public void uniqueNameNestedRealmPositive() throws XPSException {
        realm.setName(parentRealm.getName());
        this.updateObject((XPSObject)realm);
    }

    @TestBase.STI(value=14)
    public void uniqueNameNestedRealmNegative() throws XPSException {
        siblingRealm = realm.duplicate();
        siblingRealm.setResourceFilter(realm.getResourceFilter() + "_sibling");
        this.failCreate((XPSObject)siblingRealm, "Duplicate");
    }

    @TestBase.STI(value=15)
    public void NestedRealmDifferentDomain() throws XPSException {
        Domain domain = realm.getParent();
        Domain domain2 = domain.duplicate();
        domain2.setName(domain2.getName() + "_second");
        this.createObject((XPSObject)domain2);
        siblingRealm.setName(siblingRealm.getName() + "_sibling");
        siblingRealm.setParent(domain2);
        this.failCreate((XPSObject)siblingRealm, "Domain");
    }

    @TestBase.STI(value=16)
    public void testCreateNestedRealmsWithSameNameButDifferentParentRealms() throws XPSException {
        List list = domain.getChildren((IClass)Realm.ddclass);
        RealmTest.assertFalse((String)"No realms exists under \"TestRealmDomain\"", (list.size() == 0 ? 1 : 0) != 0);
        Realm realm = (Realm)list.get(0);
        String string = SetupConnection.randomize("NestedRealm");
        Realm realm2 = ObjectBuilder.makeRealm(string, realm.getAgent(), realm.getAuthScheme(), domain);
        realm2.clearResourceFilter();
        realm2.setParentRealm(realm);
        realm2.setResourceFilter("Test16_1/");
        this.createObject((XPSObject)realm2);
        String string2 = SetupConnection.randomize("NestedRealm");
        Realm realm3 = ObjectBuilder.makeRealm(string2, realm.getAgent(), realm.getAuthScheme(), domain);
        realm3.clearResourceFilter();
        realm3.setParentRealm(realm);
        realm3.setResourceFilter("Test16_2/");
        this.createObject((XPSObject)realm3);
        String string3 = SetupConnection.randomize("NestedRealm");
        Realm realm4 = ObjectBuilder.makeRealm(string3, realm.getAgent(), realm.getAuthScheme(), domain);
        realm4.clearResourceFilter();
        realm4.setParentRealm(realm2);
        realm4.setResourceFilter("Test16_1_1/");
        this.createObject((XPSObject)realm4);
        Realm realm5 = ObjectBuilder.makeRealm(string3, realm.getAgent(), realm.getAuthScheme(), domain);
        realm5.clearResourceFilter();
        realm5.setParentRealm(realm3);
        realm5.setResourceFilter("Test16_1_2/");
        this.createObject((XPSObject)realm5);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)RealmTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(RealmTest.class);
    }
}

