/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMapping;
import com.ca.siteminder.sdk.adminapi.ca.sm.IdentityMappingEntry;
import com.ca.siteminder.sdk.adminapi.ca.sm.UserDirectory;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IdentityMappingEntryTest
extends TestBase {
    static String strName;
    static IdentityMappingEntry identityMappingEntry;
    static IdentityMapping mapping;
    static UserDirectory userDir;

    @TestBase.STI(value=1)
    public void testCreateIdentityMappingEntry() throws XPSException {
        SetupConnection.builder.doIdentityMappingSetup("IdentityMappingEntry" + SetupConnection.random, "az");
        userDir = ObjectBuilder.doUserDirSetUp("userDirIdentityMappingEntry" + SetupConnection.random);
        mapping = (IdentityMapping)SetupConnection.fetchByName(IdentityMapping.ddclass, "IdentityMappingEntry" + SetupConnection.random);
        String string = "IdentityMappingEntry" + SetupConnection.random;
        identityMappingEntry = this.makeIdentityMappingEntry(string, mapping);
        this.createObject((XPSObject)identityMappingEntry);
    }

    @TestBase.STI(value=2)
    public void testSearchIdentityMappingEntry() {
        SetupConnection.fetchByName(IdentityMappingEntry.ddclass, identityMappingEntry.getName());
    }

    @TestBase.STI(value=3)
    public void testIdentityMappingEntryDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)identityMappingEntry);
    }

    @TestBase.STI(value=4)
    public void testIdentityMappingEntryWithoutName() throws XPSException {
        identityMappingEntry = this.makeIdentityMappingEntry(null, mapping);
        this.failCreate((XPSObject)identityMappingEntry, "Name");
    }

    @TestBase.STI(value=5)
    public void testIdentityMappingEntryWithoutParent() throws XPSException {
        strName = "IdentityMappingEntry2" + SetupConnection.random;
        identityMappingEntry = this.makeIdentityMappingEntry(strName, null);
        this.failCreate((XPSObject)identityMappingEntry, "parent");
    }

    @TestBase.STI(value=6)
    public void testIdentityMappingEntryWithoutExpression() throws XPSException {
        strName = "IdentityMappingEntry2" + SetupConnection.random;
        identityMappingEntry = this.makeIdentityMappingEntry(strName, mapping);
        identityMappingEntry.clearUserSearchExpression();
        this.failCreate((XPSObject)identityMappingEntry, "UserSearchExpression");
    }

    public void doMappingSetup(String string, String string2) throws XPSException {
        IdentityMapping identityMapping = ObjectBuilder.makeIdentityMapping(string, string2);
        this.createObject((XPSObject)identityMapping);
    }

    private IdentityMappingEntry makeIdentityMappingEntry(String string, IdentityMapping identityMapping) {
        IdentityMappingEntry identityMappingEntry = (IdentityMappingEntry)SetupConnection.policyData.newObject((IClass)IdentityMappingEntry.ddclass);
        if (string != null) {
            identityMappingEntry.setName(string);
        }
        identityMappingEntry.setDescription("XPSAPI JUnit Sample IdentityMappingEntry");
        identityMappingEntry.setParent(identityMapping);
        identityMappingEntry.setUserSearchExpression("Identical DN");
        identityMappingEntry.setTargetDir(userDir);
        return identityMappingEntry;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IdentityMappingEntryTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IdentityMappingEntryTest.class);
    }
}

