/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentGroup;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalRule;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.AgentGroupTest;
import java.util.Collections;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GlobalRuleTest
extends TestBase {
    static Agent agent;
    static String strName;
    static GlobalRule globalRule;

    @TestBase.STI(value=1)
    public void testCreateGlobalRule() throws XPSException {
        agent = SetupConnection.builder.doAgentSetUp("globalruleagent" + SetupConnection.random);
        strName = "GlobalRule" + SetupConnection.random;
        globalRule = ObjectBuilder.makeGlobalRule(strName, agent);
        this.createObject((XPSObject)globalRule);
    }

    @TestBase.STI(value=2)
    public void testSearchGlobalRule() {
        SetupConnection.fetchByName(GlobalRule.ddclass, globalRule.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateGlobalRule() throws XPSException {
        globalRule.setName("update" + globalRule.getName());
        globalRule.setDesc("update" + globalRule.getDesc());
        this.updateObject((XPSObject)globalRule);
    }

    @TestBase.STI(value=4)
    public void testGlobalRuleDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)globalRule, false);
    }

    @TestBase.STI(value=5)
    public void testDeleteGlobalRule() throws XPSException {
        this.deleteObject((XPSObject)globalRule);
        globalRule = null;
    }

    @TestBase.STI(value=6)
    public void testGlobalRuleWithoutName() throws XPSException {
        globalRule = ObjectBuilder.makeGlobalRule(null, agent);
        GlobalRuleTest.assertNotNull((String)"globalRule", (Object)globalRule);
        this.failCreate((XPSObject)globalRule, "Name");
    }

    @TestBase.STI(value=7)
    public void testGlobalRuleWithoutAgent() throws XPSException {
        globalRule = ObjectBuilder.makeGlobalRule(strName, null);
        this.failCreate((XPSObject)globalRule, "AgentLink");
    }

    @TestBase.STI(value=8)
    public void testGlobalRuleWithoutActions() throws XPSException {
        globalRule = ObjectBuilder.makeGlobalRule(strName, agent);
        globalRule.clearActions();
        this.failCreate((XPSObject)globalRule, "Actions");
    }

    @TestBase.STI(value=9)
    public void testGlobalRuleWithWrongActions() throws XPSException {
        globalRule = ObjectBuilder.makeGlobalRule(strName, agent);
        globalRule.setActions(Collections.singletonList("Get"));
        this.failCreate((XPSObject)globalRule, "Get");
    }

    @TestBase.STI(value=10)
    public void testCreateGlobalRuleWIthAgentGroup() throws XPSException {
        String string = "AgentGroup" + SetupConnection.random;
        AgentGroup agentGroup = AgentGroupTest.makeAgentGroup(string, agent);
        this.createObject((XPSObject)agentGroup);
        globalRule = ObjectBuilder.makeGlobalRule(strName, null);
        globalRule.setAgentGroup(agentGroup);
        this.createObject((XPSObject)globalRule);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GlobalRuleTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GlobalRuleTest.class);
    }
}

