/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Domain;
import com.ca.siteminder.sdk.adminapi.ca.sm.GlobalPolicy;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class GlobalPolicyTest
extends TestBase {
    static String strName;
    static GlobalPolicy globalPolicy;

    @TestBase.STI(value=1)
    public void testCreateGlobalPolicy() throws XPSException {
        strName = "GlobalPolicy" + SetupConnection.random;
        globalPolicy = ObjectBuilder.makeGlobalPolicy(strName);
        this.createObject((XPSObject)globalPolicy);
    }

    @TestBase.STI(value=2)
    public void testSearchGlobalPolicy() {
        SetupConnection.fetchByName(GlobalPolicy.ddclass, globalPolicy.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateGlobalPolicy() throws XPSException {
        globalPolicy.setName("update" + globalPolicy.getName());
        globalPolicy.setDesc("update" + globalPolicy.getDesc());
        this.updateObject((XPSObject)globalPolicy);
    }

    @TestBase.STI(value=4)
    public void testGlobalPolicyDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)globalPolicy, false);
    }

    @TestBase.STI(value=5)
    public void testDeleteGlobalPolicy() throws XPSException {
        this.deleteObject((XPSObject)globalPolicy);
        globalPolicy = null;
    }

    @TestBase.STI(value=6)
    public void testGlobalPolicyWithoutName() throws XPSException {
        globalPolicy = ObjectBuilder.makeGlobalPolicy(null);
        this.failCreate((XPSObject)globalPolicy, "Name");
    }

    @TestBase.STI(value=7)
    public void testGlobalPolicyWithWrongDomain() throws XPSException {
        Domain domain = ObjectBuilder.makeDomain(strName, null);
        this.createObject((XPSObject)domain);
        globalPolicy = ObjectBuilder.makeGlobalPolicy(strName);
        globalPolicy.setParent(domain);
        this.createObject((XPSObject)globalPolicy);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)GlobalPolicyTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(GlobalPolicyTest.class);
    }
}

