/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentConfig;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentInstance;
import com.ca.siteminder.sdk.adminapi.ca.sm.HostConfig;
import com.ca.siteminder.sdk.adminapi.ca.sm.TrustedHost;
import com.ca.siteminder.sdk.adminapi.dd.IAttribute;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapi.filter.Clause;
import com.ca.siteminder.sdk.adminapi.filter.Filter;
import com.ca.siteminder.sdk.adminapitest.ObjectBuilder;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import junit.textui.TestRunner;

public class AgentInstanceTest
extends TestBase {
    static AgentInstance agentInstance;

    @TestBase.STI(value=1)
    public void testCreateAgentInstance() throws XPSException {
        agentInstance = this.makeAgentInstance();
        this.createObject((XPSObject)agentInstance);
    }

    @TestBase.STI(value=2)
    public void testSearchAgentInstance() {
        Filter filter = new Filter((IAttribute)AgentInstance.PRODUCTSUBTYPE, Clause.Operator.EQUAL, (Object)("ProductSubType" + SetupConnection.random));
        List list = SetupConnection.policyData.search((IClass)AgentInstance.ddclass, filter);
        AgentInstanceTest.assertFalse((String)"policyData.search returned empty agentInstances", (list.size() == 0 ? 1 : 0) != 0);
    }

    @TestBase.STI(value=3)
    public void testUpdateAgentInstance() throws XPSException {
        agentInstance.setProductType("update" + agentInstance.getProductSubType());
        agentInstance.setProductSubType("update" + agentInstance.getProductSubType());
        this.updateObject((XPSObject)agentInstance);
    }

    @TestBase.STI(value=4)
    public void testAgentInstanceDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agentInstance);
    }

    @TestBase.STI(value=5)
    public void testDeleteAgentInstance() throws XPSException {
        this.deleteObject((XPSObject)agentInstance);
        agentInstance = null;
    }

    private AgentInstance makeAgentInstance() throws XPSException {
        AgentInstance agentInstance = (AgentInstance)SetupConnection.policyData.newObject((IClass)AgentInstance.ddclass);
        AgentConfig agentConfig = (AgentConfig)SetupConnection.fetchByName(AgentConfig.ddclass, "AgentConfig" + SetupConnection.random);
        agentInstance.setACOLink(agentConfig);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("agent1");
        arrayList.add("agent2");
        arrayList.add("agent3");
        agentInstance.setAgentsName(arrayList);
        agentInstance.setAgentIdFile("AgentIdFile" + SetupConnection.random);
        agentInstance.setConnectionIPAddress("127.0.0.1");
        agentInstance.setFIPSMode(AgentInstance.FIPSMode.UNKNOWN);
        HostConfig hostConfig = (HostConfig)SetupConnection.fetchByName(HostConfig.ddclass, "HostConfig" + SetupConnection.random);
        agentInstance.setHCOLink(hostConfig);
        agentInstance.setHeartbeatTimestamp(new Date());
        agentInstance.setOSType("OSType" + SetupConnection.random);
        agentInstance.setProductSubType("ProductSubType" + SetupConnection.random);
        agentInstance.setProductType("ProductType" + SetupConnection.random);
        agentInstance.setProductVersion("ProductVersion" + SetupConnection.random);
        agentInstance.setSystemIPAddresses("127.0.0.1");
        agentInstance.setSystemName("SystemName" + SetupConnection.random);
        TrustedHost trustedHost = (TrustedHost)SetupConnection.fetchByName(TrustedHost.ddclass, "TrustedHost" + SetupConnection.random);
        agentInstance.setTrustedHost(trustedHost);
        return agentInstance;
    }

    public void setUpSuite() {
        super.setUpSuite();
        AgentConfig agentConfig = ObjectBuilder.makeAgentConfig("AgentConfig" + SetupConnection.random);
        SetupConnection.createObject((XPSObject)agentConfig);
        HostConfig hostConfig = ObjectBuilder.makeHostConfig("HostConfig" + SetupConnection.random);
        SetupConnection.createObject((XPSObject)hostConfig);
        TrustedHost trustedHost = ObjectBuilder.makeTrustedHost("TrustedHost" + SetupConnection.random);
        SetupConnection.createObject((XPSObject)trustedHost);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)AgentInstanceTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(AgentInstanceTest.class);
    }
}

