/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.sm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.Agent4x;
import com.ca.siteminder.sdk.adminapi.ca.sm.AgentType;
import com.ca.siteminder.sdk.adminapi.ca.sm.TrustedHost;
import com.ca.siteminder.sdk.adminapi.dd.IClass;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import com.ca.siteminder.sdk.adminapitest.basic.sm.TrustedHostTest;
import junit.framework.Test;
import junit.textui.TestRunner;

public class Agent4xTest
extends TestBase {
    static Agent4x agent;
    static String strName;

    @TestBase.STI(value=1)
    public void testCreateAgent4x() throws XPSException {
        strName = "agent4x" + SetupConnection.random;
        agent = Agent4xTest.makeAgent4x(strName);
        this.createObject((XPSObject)agent);
    }

    @TestBase.STI(value=2)
    public void testSearchAgent4x() {
        SetupConnection.fetchByName(Agent4x.ddclass, agent.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateAgent4x() throws XPSException {
        agent.setName("update" + agent.getName());
        agent.setDesc("update" + agent.getDesc());
        this.updateObject((XPSObject)agent);
    }

    @TestBase.STI(value=4)
    public void testAgent4xDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)agent);
    }

    @TestBase.STI(value=5)
    public void testdeleteAgent4x() throws XPSException {
        this.deleteObject((XPSObject)agent);
        agent = null;
    }

    @TestBase.STI(value=6)
    public void testAgent4xWithoutName() throws XPSException {
        agent = Agent4xTest.makeAgent4x(null);
        this.failCreate((XPSObject)agent, "Name");
    }

    @TestBase.STI(value=7)
    public void testAgent4xWithoutAgentType() throws XPSException {
        strName = "agent4x" + SetupConnection.random;
        agent = Agent4xTest.makeAgent4x(strName);
        agent.clearAgentType();
        this.failCreate((XPSObject)agent, "AgentTypeLink");
    }

    @TestBase.STI(value=8)
    public void testAgentNameUpperCase() throws XPSException {
        strName = "agent4xZZZ" + SetupConnection.random;
        agent = Agent4xTest.makeAgent4x(strName);
        this.createObject((XPSObject)agent);
        String string = agent.getName();
        Agent4xTest.assertEquals((String)"to lower case", (String)strName.toLowerCase(), (String)string);
    }

    @TestBase.STI(value=9)
    public void testAgentNameUnicode() throws XPSException {
        strName = "agent4x\u0401\u0416" + SetupConnection.random;
        agent.setName(strName);
        this.updateObject((XPSObject)agent);
        String string = agent.getName();
        Agent4xTest.assertEquals((String)"to lower case", (String)strName.toLowerCase(), (String)string);
    }

    @TestBase.STI(value=10)
    public void testTrustedHostWithAgent4xName() throws XPSException {
        String string = "agent4x_" + SetupConnection.random;
        TrustedHost trustedHost = TrustedHostTest.makeTrustedHost(string);
        this.createObject((XPSObject)trustedHost);
        agent = Agent4xTest.makeAgent4x(string);
        this.failCreate((XPSObject)agent, "Duplicate");
    }

    public static Agent4x makeAgent4x(String string) throws XPSException {
        AgentType agentType = (AgentType)SetupConnection.fetchByName(AgentType.ddclass, "Web Agent");
        Agent4x agent4x = (Agent4x)SetupConnection.policyData.newObject((IClass)Agent4x.ddclass);
        if (string != null) {
            agent4x.setName(string);
        }
        agent4x.setAgentType(agentType);
        agent4x.setDesc("XPSAPI JUnit Sample Agent4x");
        agent4x.setRealmHintAttrId(Integer.valueOf(0));
        agent4x.setIpAddr("127.0.0.1");
        agent4x.setSecret("firewall");
        return agent4x;
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)Agent4xTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(Agent4xTest.class);
    }
}

