/*
 * Decompiled with CFR 0.152.
 */
package com.ca.siteminder.sdk.adminapitest.basic.idm;

import com.ca.siteminder.sdk.adminapi.InternalTesting;
import com.ca.siteminder.sdk.adminapi.XPSException;
import com.ca.siteminder.sdk.adminapi.XPSObject;
import com.ca.siteminder.sdk.adminapi.ca.sm.IMSTask;
import com.ca.siteminder.sdk.adminapitest.SetupConnection;
import com.ca.siteminder.sdk.adminapitest.TestBase;
import junit.framework.Test;
import junit.textui.TestRunner;

public class IMSTaskTest
extends TestBase {
    static IMSTask imsTask = null;

    @TestBase.STI(value=1)
    public void testCreateIMSTask() throws XPSException {
        String string = "IMSTask" + SetupConnection.random;
        imsTask = SetupConnection.builder.makeIMSTask(string);
        this.createObject((XPSObject)imsTask);
    }

    @TestBase.STI(value=2)
    public void testSearchIMSTask() {
        SetupConnection.fetchByName(IMSTask.ddclass, imsTask.getName());
    }

    @TestBase.STI(value=3)
    public void testUpdateIMSTask() throws XPSException {
        imsTask.setName("update" + imsTask.getName());
        imsTask.setDescription("update" + imsTask.getDescription());
        this.updateObject((XPSObject)imsTask);
    }

    @TestBase.STI(value=4)
    public void testIMSTaskDeployment() {
        InternalTesting.testDeployment(SetupConnection.session, (XPSObject)imsTask);
    }

    @TestBase.STI(value=5)
    public void testDeleteIMSTask() throws XPSException {
        this.deleteObject((XPSObject)imsTask);
        imsTask = null;
    }

    @TestBase.STI(value=6)
    public void testIMSTaskWithoutName() throws XPSException {
        imsTask = SetupConnection.builder.makeIMSTask(null);
        this.failCreate((XPSObject)imsTask, "Name");
    }

    @TestBase.STI(value=7)
    public void testIMSTaskWithoutTypeId() throws XPSException {
        String string = "IMSTask2" + SetupConnection.random;
        imsTask = SetupConnection.builder.makeIMSTask(string);
        imsTask.clearTypeId();
        this.failCreate((XPSObject)imsTask, "TypeId");
    }

    @TestBase.STI(value=8)
    public void testIMSTaskWithoutTaskFlags() throws XPSException {
        String string = "IMSTask3" + SetupConnection.random;
        imsTask = SetupConnection.builder.makeIMSTask(string);
        imsTask.clearTaskFlags();
        this.failCreate((XPSObject)imsTask, "TaskFlags");
    }

    @TestBase.STI(value=9)
    public void testIMSTaskWithoutActionType() throws XPSException {
        String string = "IMSTask4" + SetupConnection.random;
        imsTask = SetupConnection.builder.makeIMSTask(string);
        imsTask.clearActionType();
        this.failCreate((XPSObject)imsTask, "ActionType");
    }

    @TestBase.STI(value=10)
    public void testIMSTaskWithoutTaskTag() throws XPSException {
        String string = "IMSTask5" + SetupConnection.random;
        imsTask = SetupConnection.builder.makeIMSTask(string);
        imsTask.clearTaskTag();
        this.failCreate((XPSObject)imsTask, "TaskTag");
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)IMSTaskTest.suite());
    }

    public static Test suite() {
        return new SetupConnection(IMSTaskTest.class);
    }
}

